/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;

final class LDAPExtendedFutureResultImpl<R extends ExtendedResult>
extends AbstractLDAPFutureResultImpl<R> {
    private final ExtendedRequest<R> request;

    LDAPExtendedFutureResultImpl(int requestID, ExtendedRequest<R> request, ResultHandler<? super R> resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        super(requestID, resultHandler, intermediateResponseHandler, connection);
        this.request = request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPExtendedFutureResultImpl(");
        sb.append("request = ");
        sb.append(this.request);
        super.toString(sb);
        sb.append(")");
        return sb.toString();
    }

    @Override
    boolean isBindOrStartTLS() {
        return this.request.getOID().equals("1.3.6.1.4.1.1466.20037");
    }

    R decodeResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
        return this.request.getResultDecoder().decodeExtendedResult(result, options);
    }

    ExtendedRequest<R> getRequest() {
        return this.request;
    }

    @Override
    R newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        return this.request.getResultDecoder().newExtendedErrorResult(resultCode, "", diagnosticMessage);
    }
}

