/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.ASN1BufferWriter;
import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import com.forgerock.opendj.ldap.ConnectionSecurityLayerFilter;
import com.forgerock.opendj.ldap.LDAPBindFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPCompareFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPConnectionFactoryImpl;
import com.forgerock.opendj.ldap.LDAPExtendedFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPSearchFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPWriter;
import com.forgerock.opendj.ldap.TimeoutEventListener;
import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

final class LDAPConnection
extends AbstractAsynchronousConnection
implements org.forgerock.opendj.ldap.Connection,
TimeoutEventListener {
    private static final SSLEngineConfigurator DUMMY_SSL_ENGINE_CONFIGURATOR;
    private final AtomicBoolean bindOrStartTLSInProgress = new AtomicBoolean(false);
    private final Connection<?> connection;
    private final LDAPWriter ldapWriter = new LDAPWriter();
    private final AtomicInteger nextMsgID = new AtomicInteger(1);
    private final LDAPConnectionFactoryImpl factory;
    private final ConcurrentHashMap<Integer, AbstractLDAPFutureResultImpl<?>> pendingRequests = new ConcurrentHashMap();
    private final Object stateLock = new Object();
    private Result connectionInvalidReason;
    private boolean failedDueToDisconnect = false;
    private boolean isClosed = false;
    private boolean isFailed = false;
    private List<ConnectionEventListener> listeners = null;

    LDAPConnection(Connection<?> connection, LDAPConnectionFactoryImpl factory) {
        this.connection = connection;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Void> abandonAsync(AbandonRequest request) {
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
            }
        }
        catch (ErrorResultException e) {
            return new CompletedFutureResult<Void>(e);
        }
        AbstractLDAPFutureResultImpl<?> pendingRequest = this.pendingRequests.remove(request.getRequestID());
        if (pendingRequest == null) {
            return new CompletedFutureResult<Void>((Void)null);
        }
        pendingRequest.cancel(false);
        return this.sendAbandonRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FutureResult<Void> sendAbandonRequest(AbandonRequest request) {
        ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
        try {
            int messageID = this.nextMsgID.getAndIncrement();
            this.ldapWriter.abandonRequest(asn1Writer, messageID, request);
            this.connection.write((Object)asn1Writer.getBuffer(), null);
            CompletedFutureResult<Void> completedFutureResult = new CompletedFutureResult<Void>((Void)null, messageID);
            return completedFutureResult;
        }
        catch (IOException e) {
            CompletedFutureResult<Void> completedFutureResult = new CompletedFutureResult<Void>(this.adaptRequestIOException(e));
            return completedFutureResult;
        }
        finally {
            asn1Writer.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.addRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Validator.ensureNotNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            notifyClose = this.isClosed;
            notifyErrorOccurred = this.isFailed;
            if (!this.isClosed) {
                if (this.listeners == null) {
                    this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                }
                this.listeners.add(listener);
            }
        }
        if (notifyErrorOccurred) {
            listener.handleConnectionError(this.failedDueToDisconnect, ErrorResultException.newErrorResult(this.connectionInvalidReason));
        }
        if (notifyClose) {
            listener.handleConnectionClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
        BindClient context;
        int messageID = this.nextMsgID.getAndIncrement();
        try {
            context = request.createBindClient(StaticUtils.getHostName(this.factory.getSocketAddress()));
        }
        catch (Exception e) {
            Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR).setDiagnosticMessage("An error occurred while creating a bind context").setCause(e);
            ErrorResultException error = ErrorResultException.newErrorResult(errorResult);
            if (resultHandler != null) {
                resultHandler.handleErrorResult(error);
            }
            return new CompletedFutureResult<BindResult>(error, messageID);
        }
        LDAPBindFutureResultImpl future = new LDAPBindFutureResultImpl(messageID, context, resultHandler, intermediateResponseHandler, this);
        try {
            Object errorResult = this.stateLock;
            synchronized (errorResult) {
                this.checkConnectionIsValid();
                if (!this.pendingRequests.isEmpty()) {
                    future.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("There are other operations pending on this connection"));
                    return future;
                }
                if (!this.bindOrStartTLSInProgress.compareAndSet(false, true)) {
                    future.setResultOrError(Responses.newBindResult(ResultCode.OPERATIONS_ERROR).setDiagnosticMessage("Bind or Start TLS operation in progress"));
                    return future;
                }
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    GenericBindRequest initialRequest = context.nextBindRequest();
                    this.ldapWriter.bindRequest(asn1Writer, messageID, 3, initialRequest);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                this.bindOrStartTLSInProgress.set(false);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        Validator.ensureNotNull(request);
        this.close(request, false, Responses.newResult(ResultCode.CLIENT_SIDE_USER_CANCELLED).setDiagnosticMessage("Connection closed by client" + (reason != null ? ": " + reason : "")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPCompareFutureResultImpl future = new LDAPCompareFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.compareRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.deleteRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    @Override
    public long getTimeout() {
        return this.factory.getLDAPOptions().getTimeout(TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPExtendedFutureResultImpl<R> future = new LDAPExtendedFutureResultImpl<R>(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
                    if (!this.pendingRequests.isEmpty()) {
                        future.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "There are pending operations on this connection"));
                        return future;
                    }
                    if (this.isTLSEnabled()) {
                        future.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "This connection is already TLS enabled"));
                        return future;
                    }
                    if (!this.bindOrStartTLSInProgress.compareAndSet(false, true)) {
                        future.setResultOrError(request.getResultDecoder().newExtendedErrorResult(ResultCode.OPERATIONS_ERROR, "", "Bind or Start TLS operation in progress"));
                        return future;
                    }
                } else {
                    this.checkBindOrStartTLSInProgress();
                }
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.extendedRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                this.bindOrStartTLSInProgress.set(false);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.isValid0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.modifyRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.modifyDNRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Validator.ensureNotNull(listener);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
        int messageID = this.nextMsgID.getAndIncrement();
        LDAPSearchFutureResultImpl future = new LDAPSearchFutureResultImpl(messageID, request, resultHandler, intermediateResponseHandler, this);
        try {
            Object object = this.stateLock;
            synchronized (object) {
                this.checkConnectionIsValid();
                this.checkBindOrStartTLSInProgress();
                this.pendingRequests.put(messageID, future);
            }
            try {
                ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
                try {
                    this.ldapWriter.searchRequest(asn1Writer, messageID, request);
                    this.connection.write((Object)asn1Writer.getBuffer(), null);
                }
                finally {
                    asn1Writer.recycle();
                }
            }
            catch (IOException e) {
                this.pendingRequests.remove(messageID);
                throw this.adaptRequestIOException(e);
            }
        }
        catch (ErrorResultException e) {
            future.adaptErrorResult(e.getResult());
        }
        return future;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDAPConnection(");
        builder.append(this.connection.getLocalAddress());
        builder.append(',');
        builder.append(this.connection.getPeerAddress());
        builder.append(')');
        return builder.toString();
    }

    @Override
    public long handleTimeout(long currentTime) {
        long timeout = this.factory.getLDAPOptions().getTimeout(TimeUnit.MILLISECONDS);
        if (timeout <= 0L) {
            return 0L;
        }
        long delay = timeout;
        for (AbstractLDAPFutureResultImpl<?> future : this.pendingRequests.values()) {
            Result result;
            if (future == null || !future.checkForTimeout()) continue;
            long diff = future.getTimestamp() + timeout - currentTime;
            if (diff > 0L) {
                delay = Math.min(delay, diff);
                continue;
            }
            if (this.pendingRequests.remove(future.getRequestID()) == null) continue;
            if (future.isBindOrStartTLS()) {
                StaticUtils.DEBUG_LOG.fine("Failing bind or StartTLS request due to timeout (connection will be invalidated): " + future);
                result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(CoreMessages.LDAP_CONNECTION_BIND_OR_START_TLS_REQUEST_TIMEOUT.get((Object)timeout).toString());
                future.adaptErrorResult(result);
                Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(CoreMessages.LDAP_CONNECTION_BIND_OR_START_TLS_CONNECTION_TIMEOUT.get((Object)timeout).toString());
                this.connectionErrorOccurred(errorResult);
                continue;
            }
            StaticUtils.DEBUG_LOG.fine("Failing request due to timeout: " + future);
            result = Responses.newResult(ResultCode.CLIENT_SIDE_TIMEOUT).setDiagnosticMessage(CoreMessages.LDAP_CONNECTION_REQUEST_TIMEOUT.get((Object)timeout).toString());
            future.adaptErrorResult(result);
        }
        return delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(UnbindRequest unbindRequest, boolean isDisconnectNotification, Result reason) {
        List<ConnectionEventListener> tmpListeners;
        boolean notifyErrorOccurred;
        boolean notifyClose;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            if (unbindRequest != null) {
                notifyClose = true;
                notifyErrorOccurred = false;
                this.isClosed = true;
                tmpListeners = this.listeners;
                this.listeners = null;
                if (this.connectionInvalidReason == null) {
                    this.connectionInvalidReason = reason;
                }
            } else {
                if (this.isFailed) {
                    return;
                }
                notifyClose = false;
                notifyErrorOccurred = true;
                this.isFailed = true;
                this.failedDueToDisconnect = isDisconnectNotification;
                this.connectionInvalidReason = reason;
                tmpListeners = this.listeners;
            }
        }
        Iterator<Object> i$ = this.pendingRequests.keySet().iterator();
        while (i$.hasNext()) {
            int requestID = (Integer)i$.next();
            AbstractLDAPFutureResultImpl<?> future = this.pendingRequests.remove(requestID);
            if (future == null) continue;
            future.adaptErrorResult(this.connectionInvalidReason);
        }
        if (notifyClose) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                this.ldapWriter.unbindRequest(asn1Writer, this.nextMsgID.getAndIncrement(), unbindRequest);
                this.connection.write((Object)asn1Writer.getBuffer(), null);
            }
            catch (Exception requestID) {
            }
            finally {
                asn1Writer.recycle();
            }
            this.factory.getTimeoutChecker().removeListener(this);
            this.connection.closeSilently();
            this.factory.releaseTransportAndTimeoutChecker();
        }
        if (tmpListeners != null) {
            if (notifyErrorOccurred) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, ErrorResultException.newErrorResult(reason));
                }
            }
            if (notifyClose) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int continuePendingBindRequest(LDAPBindFutureResultImpl future) throws ErrorResultException {
        int newMsgID = this.nextMsgID.getAndIncrement();
        Object object = this.stateLock;
        synchronized (object) {
            this.checkConnectionIsValid();
            this.pendingRequests.put(newMsgID, future);
        }
        return newMsgID;
    }

    LDAPOptions getLDAPOptions() {
        return this.factory.getLDAPOptions();
    }

    AbstractLDAPFutureResultImpl<?> getPendingRequest(Integer messageID) {
        return this.pendingRequests.get(messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsolicitedNotification(ExtendedResult result) {
        List<ConnectionEventListener> tmpListeners;
        Object object = this.stateLock;
        synchronized (object) {
            tmpListeners = this.listeners;
        }
        if (tmpListeners != null) {
            for (ConnectionEventListener listener : tmpListeners) {
                listener.handleUnsolicitedNotification(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installFilter(Filter filter) {
        Object object = this.stateLock;
        synchronized (object) {
            FilterChain oldFilterChain = (FilterChain)this.connection.getProcessor();
            int filterIndex = oldFilterChain.size() - 1;
            if (filter instanceof SSLFilter) {
                for (int i = oldFilterChain.size() - 2; i >= 0; --i) {
                    if (oldFilterChain.get(i) instanceof ConnectionSecurityLayerFilter) continue;
                    filterIndex = i + 1;
                    break;
                }
            }
            FilterChain newFilterChain = FilterChainBuilder.stateless().addAll((List)oldFilterChain).add(filterIndex, filter).build();
            this.connection.setProcessor((Processor)newFilterChain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTLSEnabled() {
        Object object = this.stateLock;
        synchronized (object) {
            FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
            for (Filter filter : currentFilterChain) {
                if (!(filter instanceof SSLFilter)) continue;
                return true;
            }
            return false;
        }
    }

    AbstractLDAPFutureResultImpl<?> removePendingRequest(Integer messageID) {
        return this.pendingRequests.remove(messageID);
    }

    void setBindOrStartTLSInProgress(boolean state) {
        this.bindOrStartTLSInProgress.set(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTLS(SSLContext sslContext, List<String> protocols, List<String> cipherSuites, CompletionHandler<SSLEngine> completionHandler) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isTLSEnabled()) {
                throw new IllegalStateException("TLS already enabled");
            }
            SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslContext, true, false, false);
            sslEngineConfigurator.setEnabledProtocols(protocols.isEmpty() ? null : protocols.toArray(new String[protocols.size()]));
            sslEngineConfigurator.setEnabledCipherSuites(cipherSuites.isEmpty() ? null : cipherSuites.toArray(new String[cipherSuites.size()]));
            SSLFilter sslFilter = new SSLFilter(DUMMY_SSL_ENGINE_CONFIGURATOR, sslEngineConfigurator);
            this.installFilter((Filter)sslFilter);
            sslFilter.handshake(this.connection, completionHandler);
        }
    }

    private ErrorResultException adaptRequestIOException(IOException e) {
        Result errorResult = Responses.newResult(ResultCode.CLIENT_SIDE_ENCODING_ERROR).setCause(e);
        this.connectionErrorOccurred(errorResult);
        return ErrorResultException.newErrorResult(errorResult);
    }

    private void checkBindOrStartTLSInProgress() throws ErrorResultException {
        if (this.bindOrStartTLSInProgress.get()) {
            throw ErrorResultException.newErrorResult(ResultCode.OPERATIONS_ERROR, "Bind or Start TLS operation in progress");
        }
    }

    private void checkConnectionIsValid() throws ErrorResultException {
        if (!this.isValid0()) {
            if (this.failedDueToDisconnect) {
                throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_SERVER_DOWN, "Connection closed by server");
            }
            throw ErrorResultException.newErrorResult(this.connectionInvalidReason);
        }
    }

    private void connectionErrorOccurred(Result reason) {
        this.close(null, false, reason);
    }

    private boolean isValid0() {
        return !this.isFailed && !this.isClosed;
    }

    static {
        try {
            DUMMY_SSL_ENGINE_CONFIGURATOR = new SSLEngineConfigurator(new SSLContextBuilder().setTrustManager(TrustManagers.distrustAll()).getSSLContext());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create Dummy SSL Engine Configurator", e);
        }
    }
}

