/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.Responses;

final class LDAPBindFutureResultImpl
extends AbstractLDAPFutureResultImpl<BindResult> {
    private final BindClient bindClient;

    LDAPBindFutureResultImpl(int requestID, BindClient bindClient, ResultHandler<? super BindResult> resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        super(requestID, resultHandler, intermediateResponseHandler, connection);
        this.bindClient = bindClient;
    }

    @Override
    boolean isBindOrStartTLS() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPBindFutureResultImpl(");
        sb.append("bindClient = ");
        sb.append(this.bindClient);
        super.toString(sb);
        sb.append(")");
        return sb.toString();
    }

    BindClient getBindClient() {
        return this.bindClient;
    }

    @Override
    BindResult newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        return Responses.newBindResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
    }
}

