/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPCompareFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPExtendedFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPFutureResultImpl;
import com.forgerock.opendj.ldap.LDAPSearchFutureResultImpl;
import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.Validator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;

public final class InternalConnection
extends AbstractAsynchronousConnection {
    private final ServerConnection<Integer> serverConnection;
    private final List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final AtomicInteger messageID = new AtomicInteger();

    public InternalConnection(ServerConnection<Integer> serverConnection) {
        this.serverConnection = serverConnection;
    }

    @Override
    public FutureResult<Void> abandonAsync(AbandonRequest request) {
        int i = this.messageID.getAndIncrement();
        this.serverConnection.handleAbandon(i, request);
        return new CompletedFutureResult<Void>((Void)null, i);
    }

    @Override
    public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleAdd(i, request, future, future);
        return future;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        Validator.ensureNotNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
        int i = this.messageID.getAndIncrement();
        InternalBindFutureResultImpl future = new InternalBindFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleBind(i, 3, request, future, future);
        return future;
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        int i = this.messageID.getAndIncrement();
        this.serverConnection.handleConnectionClosed(i, request);
    }

    @Override
    public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPCompareFutureResultImpl future = new LDAPCompareFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleCompare(i, request, future, future);
        return future;
    }

    @Override
    public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleDelete(i, request, future, future);
        return future;
    }

    @Override
    public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPExtendedFutureResultImpl<? super R> future = new LDAPExtendedFutureResultImpl<R>(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleExtendedRequest(i, request, future, future);
        return future;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleModify(i, request, future, future);
        return future;
    }

    @Override
    public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPFutureResultImpl future = new LDAPFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleModifyDN(i, request, future, future);
        return future;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Validator.ensureNotNull(listener);
        this.listeners.remove(listener);
    }

    @Override
    public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
        int i = this.messageID.getAndIncrement();
        LDAPSearchFutureResultImpl future = new LDAPSearchFutureResultImpl(i, request, resultHandler, intermediateResponseHandler, this);
        this.serverConnection.handleSearch(i, request, future, future);
        return future;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternalConnection(");
        builder.append(String.valueOf(this.serverConnection));
        builder.append(')');
        return builder.toString();
    }

    private static final class InternalBindFutureResultImpl
    extends AbstractLDAPFutureResultImpl<BindResult> {
        private final BindRequest bindRequest;

        InternalBindFutureResultImpl(int messageID, BindRequest bindRequest, ResultHandler<? super BindResult> resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
            super(messageID, resultHandler, intermediateResponseHandler, connection);
            this.bindRequest = bindRequest;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("InternalBindFutureResultImpl(");
            sb.append("bindRequest = ");
            sb.append(this.bindRequest);
            super.toString(sb);
            sb.append(")");
            return sb.toString();
        }

        @Override
        BindResult newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
            return Responses.newBindResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
        }
    }
}

