/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.nio.transport.TCPNIOConnection;

final class GrizzlyUtils {
    static void configureConnection(Connection<?> connection, boolean tcpNoDelay, boolean keepAlive, boolean reuseAddress, int linger) {
        connection.configureBlocking(true);
        SocketChannel channel = (SocketChannel)((TCPNIOConnection)connection).getChannel();
        Socket socket = channel.socket();
        try {
            socket.setTcpNoDelay(tcpNoDelay);
        }
        catch (SocketException e) {
            StaticUtils.DEBUG_LOG.log(Level.FINE, "Unable to set TCP_NODELAY to " + tcpNoDelay + " on client connection", e);
        }
        try {
            socket.setKeepAlive(keepAlive);
        }
        catch (SocketException e) {
            StaticUtils.DEBUG_LOG.log(Level.FINE, "Unable to set SO_KEEPALIVE to " + keepAlive + " on client connection", e);
        }
        try {
            socket.setReuseAddress(reuseAddress);
        }
        catch (SocketException e) {
            StaticUtils.DEBUG_LOG.log(Level.FINE, "Unable to set SO_REUSEADDR to " + reuseAddress + " on client connection", e);
        }
        try {
            if (linger < 0) {
                socket.setSoLinger(false, 0);
            } else {
                socket.setSoLinger(true, linger);
            }
        }
        catch (SocketException e) {
            StaticUtils.DEBUG_LOG.log(Level.FINE, "Unable to set SO_LINGER to " + linger + " on client connection", e);
        }
    }

    private GrizzlyUtils() {
    }
}

