/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Result;

abstract class AbstractLDAPFutureResultImpl<S extends Result>
extends AsynchronousFutureResult<S, ResultHandler<? super S>>
implements IntermediateResponseHandler {
    private final Connection connection;
    private IntermediateResponseHandler intermediateResponseHandler;
    private volatile long timestamp;

    AbstractLDAPFutureResultImpl(int requestID, ResultHandler<? super S> resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        super(resultHandler, requestID);
        this.connection = connection;
        this.intermediateResponseHandler = intermediateResponseHandler;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public final boolean handleIntermediateResponse(IntermediateResponse response) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.intermediateResponseHandler != null && !this.intermediateResponseHandler.handleIntermediateResponse(response)) {
                this.intermediateResponseHandler = null;
            }
        }
        return true;
    }

    @Override
    protected final ErrorResultException handleCancelRequest(boolean mayInterruptIfRunning) {
        this.connection.abandonAsync(Requests.newAbandonRequest(this.getRequestID()));
        return null;
    }

    @Override
    protected final boolean isCancelable() {
        return !this.isBindOrStartTLS();
    }

    boolean isBindOrStartTLS() {
        return false;
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(" requestID = ");
        sb.append(this.getRequestID());
        sb.append(" timestamp = ");
        sb.append(this.timestamp);
        super.toString(sb);
    }

    final void adaptErrorResult(Result result) {
        S errorResult = this.newErrorResult(result.getResultCode(), result.getDiagnosticMessage(), result.getCause());
        this.setResultOrError(errorResult);
    }

    final long getTimestamp() {
        return this.timestamp;
    }

    abstract S newErrorResult(ResultCode var1, String var2, Throwable var3);

    final void setResultOrError(S result) {
        if (result.getResultCode().isExceptional()) {
            this.handleErrorResult(ErrorResultException.newErrorResult(result));
        } else {
            this.handleResult(result);
        }
    }

    final void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    boolean checkForTimeout() {
        return true;
    }
}

