/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.xss;

import com.h3xstream.findsecbugs.common.InterfaceUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class XSSRequestWrapperDetector
implements Detector {
    private static final String XSS_REQUEST_WRAPPER_TYPE = "XSS_REQUEST_WRAPPER";
    private BugReporter bugReporter;

    public XSSRequestWrapperDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        boolean isRequestWrapper;
        JavaClass javaClass = classContext.getJavaClass();
        boolean bl = isRequestWrapper = InterfaceUtils.isSubtype(javaClass, "javax.servlet.http.HttpServletRequestWrapper") || InterfaceUtils.isSubtype(javaClass, "jakarta.servlet.http.HttpServletRequestWrapper");
        if (!isRequestWrapper) {
            return;
        }
        for (Method m : methodList = javaClass.getMethods()) {
            if (!m.getName().equals("stripXSS")) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, XSS_REQUEST_WRAPPER_TYPE, 2).addClassAndMethod(javaClass, m));
            return;
        }
    }

    public void report() {
    }
}

