/*
 * Decompiled with CFR 0.152.
 */
package com.h3xstream.findsecbugs.taintanalysis.extra;

import com.h3xstream.findsecbugs.FindSecBugsGlobalConfig;
import com.h3xstream.findsecbugs.common.matcher.InstructionDSL;
import com.h3xstream.findsecbugs.common.matcher.InvokeMatcherBuilder;
import com.h3xstream.findsecbugs.injection.BasicInjectionDetector;
import com.h3xstream.findsecbugs.taintanalysis.Taint;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrame;
import com.h3xstream.findsecbugs.taintanalysis.TaintFrameAdditionalVisitor;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;

public class JstlExpressionWhiteLister
extends BasicInjectionDetector
implements TaintFrameAdditionalVisitor {
    private static final String SYSTEM_PROPERTY = "findsecbugs.jstlsafe.customregexfile";
    private static final Pattern TAG_FOR_HTML_CONTENT_PATTERN = Pattern.compile("\\$\\{e:forHtmlContent\\([a-zA-Z0-9\\._]+\\)\\}");
    private static final Pattern TAG_TO_SAFE_JSON_PATTERN = Pattern.compile("^\\$\\{\\s*[a-zA-Z]+:toSafeJSON\\([a-zA-Z0-9\\-#,\\'\\\"\\&\\[\\]@\\\\ \\._\\(\\):]+\\)\\s*\\}$");
    private static final Pattern TAG_SAFE_QUOTE_PATTERN = Pattern.compile("^\\$\\{\\s*[a-zA-Z]+:safeQuote\\([a-zA-Z0-9\\-#,\\'\\\"\\&\\[\\]@\\\\ \\._\\(\\):]+\\)\\s*\\}$");
    private static final String CONTEXT_PATH_PATTERN = "${pageContext.request.contextPath}";
    private static final InvokeMatcherBuilder JAVAX_PROPRIETARY_EVALUATE = InstructionDSL.invokeInstruction().atClass("org/apache/jasper/runtime/PageContextImpl").atMethod("proprietaryEvaluate").withArgs("(Ljava/lang/String;Ljava/lang/Class;Ljavax/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;)Ljava/lang/Object;");
    private static final InvokeMatcherBuilder JAKARTA_PROPRIETARY_EVALUATE = InstructionDSL.invokeInstruction().atClass("org/apache/jasper/runtime/PageContextImpl").atMethod("proprietaryEvaluate").withArgs("(Ljava/lang/String;Ljava/lang/Class;Ljakarta/servlet/jsp/PageContext;Lorg/apache/jasper/runtime/ProtectedFunctionMapper;)Ljava/lang/Object;");
    private final List<Pattern> safePatterns = JstlExpressionWhiteLister.getCustomPatterns();

    public JstlExpressionWhiteLister(BugReporter bugReporter) {
        super(bugReporter);
        this.registerVisitor(this);
    }

    @Override
    public void visitInvoke(InvokeInstruction invoke, MethodGen methodGen, TaintFrame frameType, List<Taint> parameters, ConstantPoolGen cpg) throws DataflowAnalysisException {
        Taint defaultVal;
        if (this.isProprietaryEvaluateMethod(invoke, cpg) && (defaultVal = parameters.get(3)).getConstantValue() != null) {
            String expression = defaultVal.getConstantValue();
            if (TAG_FOR_HTML_CONTENT_PATTERN.matcher(expression).find() || TAG_TO_SAFE_JSON_PATTERN.matcher(expression).find() || TAG_SAFE_QUOTE_PATTERN.matcher(expression).find() || CONTEXT_PATH_PATTERN.equals(expression)) {
                Taint value = (Taint)frameType.getTopValue();
                value.addTag(Taint.Tag.XSS_SAFE);
            } else {
                for (Pattern safePattern : this.safePatterns) {
                    if (!safePattern.matcher(expression).find()) continue;
                    Taint value = (Taint)frameType.getTopValue();
                    value.addTag(Taint.Tag.XSS_SAFE);
                }
            }
        }
    }

    private boolean isProprietaryEvaluateMethod(InvokeInstruction invoke, ConstantPoolGen cpg) {
        return JAVAX_PROPRIETARY_EVALUATE.matches((Instruction)invoke, cpg) || JAKARTA_PROPRIETARY_EVALUATE.matches((Instruction)invoke, cpg);
    }

    @Override
    public void visitLoad(LoadInstruction load, MethodGen methodGen, TaintFrame frameType, int numProduced, ConstantPoolGen cpg) {
    }

    @Override
    public void visitField(FieldInstruction put, MethodGen methodGen, TaintFrame frameType, Taint taintFrame, int numProduced, ConstantPoolGen cpg) throws Exception {
    }

    @Override
    public void visitReturn(MethodGen methodGen, Taint returnValue, ConstantPoolGen cpg) throws Exception {
    }

    private static List<Pattern> getCustomPatterns() {
        ArrayList<Pattern> safePatterns = new ArrayList<Pattern>();
        String propertyValue = FindSecBugsGlobalConfig.getInstance().loadFromSystem(SYSTEM_PROPERTY, "");
        if (!propertyValue.trim().equals("")) {
            for (String patternFile : propertyValue.split(File.pathSeparator)) {
                safePatterns.addAll(JstlExpressionWhiteLister.customPatternsFromFile(patternFile));
            }
        }
        return safePatterns;
    }

    private static List<Pattern> customPatternsFromFile(String path) {
        List<Pattern> list;
        block9: {
            File file = new File(path);
            InputStream stream = file.exists() ? new FileInputStream(file) : JstlExpressionWhiteLister.class.getClassLoader().getResourceAsStream(path);
            try {
                if (stream == null) {
                    String message = String.format("Could not add custom patterns. Neither file %s nor resource matching %s found.", file.getAbsolutePath(), path);
                    throw new IllegalArgumentException(message);
                }
                list = JstlExpressionWhiteLister.patternsFromStream(stream);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Cannot load custom safe regex patterns from " + path, ex);
                }
            }
            stream.close();
        }
        return list;
    }

    private static List<Pattern> patternsFromStream(InputStream stream) throws IOException {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ("".equals(line.trim())) continue;
                patterns.add(Pattern.compile(line));
            }
        }
        return patterns;
    }
}

