/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.siterenderer;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.doxia.siterenderer.DefaultSiteRenderer;
import org.codehaus.plexus.util.PathTool;

public class DocumentRenderingContext {
    private final File basedir;
    private final String basedirRelativePath;
    private final String inputPath;
    private final String outputPath;
    private final String parserId;
    private final String relativePath;
    private final String extension;
    private Map<String, String> attributes;
    private final boolean editable;
    private final String generator;

    public DocumentRenderingContext(File basedir, String document, String generator) {
        this(basedir, null, document, null, null, false, generator);
    }

    public DocumentRenderingContext(File basedir, String basedirRelativePath, String document, String parserId, String extension, boolean editable) {
        this(basedir, basedirRelativePath, document, parserId, extension, editable, null);
    }

    public DocumentRenderingContext(File basedir, String basedirRelativePath, String document, String parserId, String extension, boolean editable, String generator) {
        this.basedir = basedir;
        this.parserId = parserId;
        this.extension = extension;
        this.generator = generator;
        this.attributes = new HashMap<String, String>();
        this.inputPath = document = document.replace('\\', '/');
        if (extension != null && !extension.isEmpty()) {
            this.basedirRelativePath = basedirRelativePath.replace('\\', '/');
            this.editable = editable;
            if (DefaultSiteRenderer.endsWithIgnoreCase(document, ".vm")) {
                document = document.substring(0, document.length() - 3);
            }
            String filePathWithoutExt = document.substring(0, document.length() - extension.length() - 1);
            this.outputPath = filePathWithoutExt + ".html";
        } else {
            this.basedirRelativePath = null;
            this.editable = false;
            this.outputPath = document + ".html";
        }
        this.relativePath = PathTool.getRelativePath((String)basedir.getPath(), (String)new File(basedir, this.inputPath).getPath()).replace('\\', '/');
    }

    public File getBasedir() {
        return this.basedir;
    }

    public String getInputPath() {
        return this.inputPath;
    }

    @Deprecated
    public String getInputName() {
        return this.getInputPath();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    @Deprecated
    public String getOutputName() {
        return this.getOutputPath();
    }

    public String getParserId() {
        return this.parserId;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public String getExtension() {
        return this.extension;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isDoxiaSource() {
        return this.extension != null && !this.extension.isEmpty();
    }

    public String getGenerator() {
        return this.generator;
    }

    public String getBasedirRelativePath() {
        return this.basedirRelativePath;
    }

    public String getDoxiaSourcePath() {
        return this.isDoxiaSource() ? this.basedirRelativePath + '/' + this.inputPath : null;
    }

    public String getDoxiaSourcePath(String base) {
        return PathTool.calculateLink((String)this.getDoxiaSourcePath(), (String)base);
    }
}

