/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.cwe.Weakness;
import edu.umd.cs.findbugs.cwe.WeaknessCatalog;
import edu.umd.cs.findbugs.sarif.GUIDCalculator;
import edu.umd.cs.findbugs.sarif.Level;
import edu.umd.cs.findbugs.sarif.Location;
import edu.umd.cs.findbugs.sarif.Message;
import edu.umd.cs.findbugs.sarif.MessageFormat;
import edu.umd.cs.findbugs.sarif.Placeholder;
import edu.umd.cs.findbugs.sarif.Result;
import edu.umd.cs.findbugs.sarif.Rule;
import edu.umd.cs.findbugs.sarif.Taxon;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;

class BugCollectionAnalyser {
    @NonNull
    private final List<Rule> rules = new ArrayList<Rule>();
    @NonNull
    private final List<Result> results = new ArrayList<Result>();
    @NonNull
    private final Map<String, Integer> typeToIndex = new HashMap<String, Integer>();
    @NonNull
    private final List<List<Placeholder>> indexToPlaceholders = new ArrayList<List<Placeholder>>();
    @NonNull
    private final SortedSet<Taxon> taxa = new TreeSet<Taxon>();
    @NonNull
    private final Map<URI, String> baseToId = new HashMap<URI, String>();

    BugCollectionAnalyser(@NonNull BugCollection bugCollection) {
        SourceFinder sourceFinder = bugCollection.getProject().getSourceFinder();
        bugCollection.forEach(bug -> {
            String type = bug.getType();
            BugPattern bugPattern = bug.getBugPattern();
            int index = this.typeToIndex.computeIfAbsent(type, t -> this.processRule(bugPattern));
            this.processTaxon(bugPattern.getCWEid());
            this.processResult(index, (BugInstance)bug, sourceFinder);
        });
    }

    JsonArray getRules() {
        JsonArray array = new JsonArray();
        this.rules.stream().map(Rule::toJsonObject).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    JsonArray getResults() {
        JsonArray array = new JsonArray();
        this.results.stream().map(Result::toJsonObject).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
        return array;
    }

    JsonObject getCweTaxonomy() {
        JsonObject cweTaxonomy = null;
        if (!this.taxa.isEmpty()) {
            cweTaxonomy = this.createCweTaxonomyJson();
        }
        return cweTaxonomy;
    }

    @NonNull
    JsonObject getOriginalUriBaseIds() {
        JsonObject result = new JsonObject();
        this.baseToId.forEach((uri, uriBaseId) -> {
            JsonObject uriJson = new JsonObject();
            uriJson.addProperty("uri", uri.toString());
            result.add(uriBaseId, (JsonElement)uriJson);
        });
        return result;
    }

    private JsonObject createCweTaxonomyJson() {
        JsonObject cweTaxonomy = new JsonObject();
        WeaknessCatalog weaknessCatalog = WeaknessCatalog.getInstance();
        String name = weaknessCatalog.getName();
        String version = weaknessCatalog.getVersion();
        LocalDate releaseDate = weaknessCatalog.getReleaseDate();
        UUID cweTaxonomyGuid = GUIDCalculator.fromString(name + version);
        JsonArray taxaJson = new JsonArray();
        this.taxa.stream().map(Taxon::toJsonObject).forEach(arg_0 -> ((JsonArray)taxaJson).add(arg_0));
        JsonObject shortDescriptionJson = new JsonObject();
        shortDescriptionJson.addProperty("text", "The MITRE Common Weakness Enumeration");
        cweTaxonomy.addProperty("name", name);
        cweTaxonomy.addProperty("version", version);
        cweTaxonomy.addProperty("minimumRequiredLocalizedDataSemanticVersion", version);
        cweTaxonomy.addProperty("releaseDateUtc", releaseDate.toString());
        cweTaxonomy.addProperty("guid", cweTaxonomyGuid.toString());
        cweTaxonomy.addProperty("informationUri", "https://cwe.mitre.org/data/published/cwe_v" + version + ".pdf/");
        cweTaxonomy.addProperty("downloadUri", "https://cwe.mitre.org/data/xml/cwec_v" + version + ".xml.zip");
        cweTaxonomy.addProperty("isComprehensive", Boolean.valueOf(true));
        cweTaxonomy.addProperty("organization", "MITRE");
        cweTaxonomy.addProperty("language", "en");
        cweTaxonomy.add("shortDescription", (JsonElement)shortDescriptionJson);
        cweTaxonomy.add("taxa", (JsonElement)taxaJson);
        return cweTaxonomy;
    }

    private void processResult(int index, BugInstance bug, SourceFinder sourceFinder) {
        List<String> arguments = this.indexToPlaceholders.get(index).stream().map(placeholder -> placeholder.toArgument(bug.getAnnotations(), bug.getPrimaryClass())).collect(Collectors.toList());
        ArrayList<Location> locations = new ArrayList<Location>();
        Location.fromBugInstance(bug, sourceFinder, this.baseToId).ifPresent(locations::add);
        int bugRank = BugRanker.findRank(bug);
        Message msg = new Message(arguments);
        msg.text = bug.getBugPattern().getShortDescription();
        Result result = new Result(bug.getType(), index, msg, locations, Level.fromBugRank(bugRank));
        this.results.add(result);
    }

    private int processRule(BugPattern bugPattern) {
        assert (this.indexToPlaceholders.size() == this.rules.size());
        int ruleIndex = this.rules.size();
        ArrayList placeholders = new ArrayList();
        MessageFormat formatter = new MessageFormat(bugPattern.getLongDescription());
        String formattedMessage = formatter.format((index, key) -> {
            int indexOfPlaceholder = placeholders.size();
            placeholders.add(new Placeholder((int)index, (String)key));
            return String.format("{%d}", indexOfPlaceholder);
        });
        Rule rule = Rule.fromBugPattern(bugPattern, formattedMessage);
        this.rules.add(rule);
        this.indexToPlaceholders.add(placeholders);
        return ruleIndex;
    }

    private void processTaxon(int cweid) {
        WeaknessCatalog weaknessCatalog = WeaknessCatalog.getInstance();
        Weakness weakness = weaknessCatalog.getWeaknessByCweIdOrNull(cweid);
        UUID cweTaxonomyGuid = GUIDCalculator.fromString(weaknessCatalog.getName() + weaknessCatalog.getVersion());
        if (weakness != null) {
            UUID cweGuid = GUIDCalculator.fromNamespaceAndString(cweTaxonomyGuid, String.valueOf(cweid));
            Level severityLevel = Level.fromWeaknessSeverity(weakness.getSeverity());
            Taxon taxon = Taxon.from(String.valueOf(weakness.getCweId()), cweGuid, weakness.getName(), weakness.getDescription(), severityLevel);
            this.taxa.add(taxon);
        }
    }

    Map<URI, String> getBaseToId() {
        return this.baseToId;
    }
}

