/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.regex.Pattern;

public class ViewFilter {
    final MainFrame mf;
    RankFilter rank = RankFilter.ALL;
    PriorityFilter priority = PriorityFilter.ALL_BUGS;
    String[] classSearchStrings;
    static final Pattern legalClassSearchString = Pattern.compile("[\\p{javaLowerCase}\\p{javaUpperCase}0-9.$/_]*");

    public ViewFilter(MainFrame mf) {
        this.mf = mf;
    }

    void setPackagesToDisplay(String value) {
        if ((value = value.replace('/', '.').trim()).length() == 0) {
            this.classSearchStrings = new String[0];
        } else {
            String[] parts;
            for (String p : parts = value.split("[ ,:]+")) {
                if (legalClassSearchString.matcher(p).matches()) continue;
                throw new IllegalArgumentException("Classname filter must be legal Java identifier: " + p);
            }
            this.classSearchStrings = parts;
        }
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public RankFilter getRank() {
        return this.rank;
    }

    public void setRank(RankFilter rank) {
        this.rank = rank;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public PriorityFilter getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityFilter priority) {
        this.priority = priority;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public String[] getPackagePrefixes() {
        return this.classSearchStrings;
    }

    public boolean showIgnoringPackagePrefixes(BugInstance b) {
        return this.rank.show(this.mf, b) && this.priority.show(this.mf, b);
    }

    @Deprecated
    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        return ClassName.matchedPrefixes(classSearchStrings, className);
    }

    public boolean show(BugInstance b) {
        String className = b.getPrimaryClass().getClassName();
        return ClassName.matchedPrefixes(this.classSearchStrings, className) && this.showIgnoringPackagePrefixes(b);
    }

    static enum RankFilter implements ViewFilterEnum
    {
        SCARIEST(4, "Scariest"),
        SCARY(9, "Scary"),
        TROUBLING(14, "Troubling"),
        ALL(Integer.MAX_VALUE, "All bug ranks");

        final int maxRank;
        final String displayName;

        private RankFilter(int maxRank, String displayName) {
            this.maxRank = maxRank;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            int rank = BugRanker.findRank(b);
            return rank <= this.maxRank;
        }

        public String toString() {
            if (this.maxRank < Integer.MAX_VALUE) {
                return this.displayName + " (Ranks 1 - " + this.maxRank + ")";
            }
            return this.displayName;
        }
    }

    static enum PriorityFilter implements ViewFilterEnum
    {
        HIGH_PRIORITY(1, "High priority only"),
        NORMAL_PRIORITY(2, "High and normal priority"),
        ALL_BUGS(10, "All bug priorities");

        final int maxPriority;
        final String displayName;

        private PriorityFilter(int maxPriority, String displayName) {
            this.maxPriority = maxPriority;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            return b.getPriority() <= this.maxPriority;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static interface ViewFilterEnum {
        public boolean show(MainFrame var1, BugInstance var2);
    }
}

