/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.gui2.AnalyzingDialog;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FBDialog;
import edu.umd.cs.findbugs.gui2.FBFileChooser;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.MainFrameHelper;
import edu.umd.cs.findbugs.gui2.ProjectSettings;
import edu.umd.cs.findbugs.gui2.SourceDirectoryWizard;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class NewProjectWizard
extends FBDialog {
    private final EmptyBorder border = new EmptyBorder(5, 5, 5, 5);
    private Project project;
    private boolean projectChanged = false;
    private boolean projectNameChanged = false;
    private final FBFileChooser chooser = new FBFileChooser();
    private final FileFilter directoryOrArchive = new FileFilter(){

        @Override
        public boolean accept(File f) {
            String fileName = f.getName().toLowerCase();
            return f.isDirectory() || fileName.endsWith(".jar") || fileName.endsWith(".ear") || fileName.endsWith(".war") || fileName.endsWith(".zip") || fileName.endsWith(".sar") || fileName.endsWith(".class");
        }

        @Override
        public String getDescription() {
            return L10N.getLocalString("file.accepted_extensions", "Class archive files (*.class, *.[jwes]ar, *.zip)");
        }
    };
    private final JList<String> analyzeList = new JList();
    private final DefaultListModel<String> analyzeModel = new DefaultListModel();
    private final JTextField projectName = new JTextField();
    private final JList<String> auxList = new JList();
    private final DefaultListModel<String> auxModel = new DefaultListModel();
    private final JList<String> sourceList = new JList();
    private final DefaultListModel<String> sourceModel = new DefaultListModel();
    private final JButton finishButton = new JButton();
    private final JButton cancelButton = new JButton(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
    private final JComponent[] wizardComponents = new JComponent[3];
    private boolean isNewProject;

    public NewProjectWizard() {
        this((Project)null);
        this.finishButton.setEnabled(false);
    }

    public NewProjectWizard(Project curProject) {
        this.project = curProject;
        if (this.project == null) {
            ProjectSettings.newInstance();
            this.project = new Project();
            this.isNewProject = true;
        }
        boolean temp = false;
        if (curProject == null) {
            this.setTitle(L10N.getLocalString("dlg.new_item", "New Project"));
        } else {
            this.setTitle(L10N.getLocalString("dlg.reconfig", "Reconfigure"));
            temp = true;
        }
        final boolean reconfig = temp;
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        this.wizardComponents[0] = this.createFilePanel(L10N.getLocalString("dlg.class_jars_dirs_lbl", "Class archives and directories to analyze:"), this.analyzeList, this.analyzeModel, 2, this.directoryOrArchive, "Choose Class Archives and Directories to Analyze", false, "http://findbugs.sourceforge.net/manual/gui.html#d0e1087");
        this.wizardComponents[1] = this.createFilePanel(L10N.getLocalString("dlg.aux_class_lbl", "Auxiliary class locations:"), this.auxList, this.auxModel, 2, this.directoryOrArchive, "Choose Auxiliary Class Archives and Directories", false, "http://findbugs.sourceforge.net/FAQ.html#q4");
        this.wizardComponents[2] = this.createFilePanel(L10N.getLocalString("dlg.source_dirs_lbl", "Source directories:"), this.sourceList, this.sourceModel, 2, null, "Choose Source Directories", true, "http://findbugs.sourceforge.net/manual/gui.html#d0e1087");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        if (MainFrameHelper.isMacLookAndFeel()) {
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.cancelButton);
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.finishButton);
        } else {
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.finishButton);
            buttons.add(Box.createHorizontalStrut(5));
            buttons.add(this.cancelButton);
        }
        this.finishButton.addActionListener(new ActionListener(){
            boolean keepGoing = false;

            private boolean displayWarningAndAskIfWeShouldContinue(String msg, String title) {
                boolean result;
                if (this.keepGoing) {
                    return true;
                }
                boolean bl = result = JOptionPane.showConfirmDialog(NewProjectWizard.this, msg, title, 2, 2) == 0;
                if (result) {
                    this.keepGoing = true;
                }
                return result;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                String name;
                int i;
                if (this.displayWarnings()) {
                    return;
                }
                Project p = NewProjectWizard.this.project;
                p.setGuiCallback(MainFrame.getInstance().getGuiCallback());
                NewProjectWizard.this.clearProjectSettings(p);
                for (i = 0; i < NewProjectWizard.this.analyzeModel.getSize(); ++i) {
                    p.addFile(NewProjectWizard.this.analyzeModel.get(i));
                }
                for (i = 0; i < NewProjectWizard.this.auxModel.getSize(); ++i) {
                    p.addAuxClasspathEntry(NewProjectWizard.this.auxModel.get(i));
                }
                ArrayList<String> sourceDirs = new ArrayList<String>(NewProjectWizard.this.sourceModel.getSize());
                for (int i2 = 0; i2 < NewProjectWizard.this.sourceModel.getSize(); ++i2) {
                    sourceDirs.add(NewProjectWizard.this.sourceModel.get(i2));
                }
                p.addSourceDirs(sourceDirs);
                p.setProjectName(NewProjectWizard.this.projectName.getText());
                MainFrame mainFrame = MainFrame.getInstance();
                if (this.keepGoing) {
                    mainFrame.setProject(p);
                }
                if (NewProjectWizard.this.projectChanged && (NewProjectWizard.this.isNewProject || JOptionPane.showConfirmDialog(NewProjectWizard.this, L10N.getLocalString("dlg.project_settings_changed_lbl", "Project settings have been changed.  Perform a new analysis with the changed files?"), L10N.getLocalString("dlg.redo_analysis_question_lbl", "Redo analysis?"), 0) == 0)) {
                    AnalyzingDialog.show(p);
                }
                if (reconfig) {
                    mainFrame.setProjectChanged(true);
                }
                if ((name = p.getProjectName()) == null) {
                    name = "<<unnamed project>>";
                    Debug.println("PROJECT NAME IS NULL!!");
                }
                if (NewProjectWizard.this.projectNameChanged) {
                    mainFrame.updateTitle();
                }
                NewProjectWizard.this.dispose();
            }

            private boolean displayWarnings() {
                File temp;
                int i;
                for (i = 0; i < NewProjectWizard.this.analyzeModel.getSize(); ++i) {
                    temp = new File(NewProjectWizard.this.analyzeModel.get(i));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return true;
                }
                for (i = 0; i < NewProjectWizard.this.sourceModel.getSize(); ++i) {
                    temp = new File(NewProjectWizard.this.sourceModel.get(i));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return true;
                }
                for (i = 0; i < NewProjectWizard.this.auxModel.getSize(); ++i) {
                    temp = new File(NewProjectWizard.this.auxModel.get(i));
                    if (temp.exists() || !NewProjectWizard.this.directoryOrArchive.accept(temp) || this.displayWarningAndAskIfWeShouldContinue(temp.getName() + " " + L10N.getLocalString("dlg.invalid_txt", " is invalid."), L10N.getLocalString("dlg.error_ttl", "Can't locate file"))) continue;
                    return true;
                }
                return false;
            }
        });
        if (curProject == null) {
            this.finishButton.setText(L10N.getLocalString("dlg.analyze_btn", "Analyze"));
        } else {
            this.finishButton.setText(L10N.getLocalString("dlg.ok_btn", "OK"));
        }
        this.cancelButton.addActionListener(evt -> this.dispose());
        JPanel south = new JPanel(new BorderLayout());
        south.setBorder(new EmptyBorder(5, 5, 5, 5));
        south.add((Component)new JSeparator(), "North");
        south.add((Component)buttons, "East");
        if (curProject != null) {
            for (String i : curProject.getFileList()) {
                this.analyzeModel.addElement(i);
            }
            for (String i : curProject.getAuxClasspathEntryList()) {
                this.auxModel.addElement(i);
            }
            for (String i : curProject.getSourceDirList()) {
                this.sourceModel.addElement(i);
            }
            this.projectName.setText(curProject.getProjectName());
            this.projectName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    NewProjectWizard.this.projectNameChanged = true;
                }
            });
        } else {
            this.finishButton.setEnabled(false);
        }
        this.loadAllPanels(mainPanel);
        this.add((Component)this.createTextFieldPanel("Project name", this.projectName), "North");
        this.add((Component)mainPanel, "Center");
        this.add((Component)south, "South");
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setVisible(true);
    }

    private void clearProjectSettings(Project p) {
        int numOldFiles = p.getFileCount();
        for (int x = 0; x < numOldFiles; ++x) {
            p.removeFile(0);
        }
        int numOldAuxFiles = p.getNumAuxClasspathEntries();
        for (int x = 0; x < numOldAuxFiles; ++x) {
            p.removeAuxClasspathEntry(0);
        }
        int numOldSrc = p.getNumSourceDirs();
        for (int x = 0; x < numOldSrc; ++x) {
            p.removeSourceDir(0);
        }
    }

    private JComponent createTextFieldPanel(String label, JTextField textField) {
        JPanel myPanel = new JPanel(new BorderLayout());
        myPanel.add((Component)new JLabel(label), "North");
        myPanel.add((Component)textField, "Center");
        myPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        return myPanel;
    }

    private JPanel createFilePanel(String label, JList<String> list, DefaultListModel<String> listModel, int fileSelectionMode, FileFilter filter, String dialogTitle, boolean wizard, String helpUrl) {
        JPanel myPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        myPanel.add((Component)new JLabel(label), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        JButton button = new JButton("<HTML><U>Help");
        button.setFont(button.getFont().deriveFont(0));
        button.setForeground(Color.BLUE);
        button.setBorderPainted(false);
        button.setCursor(Cursor.getPredefinedCursor(12));
        button.setContentAreaFilled(false);
        button.addActionListener(e -> {
            try {
                LaunchBrowser.showDocument(new URL(helpUrl));
            }
            catch (MalformedURLException e1) {
                throw new IllegalStateException(e1);
            }
        });
        myPanel.add((Component)button, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridheight = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        myPanel.add((Component)new JScrollPane(list), gbc);
        list.setModel(listModel);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        JButton addButton = new JButton(L10N.getLocalString("dlg.add_btn", "Add"));
        myPanel.add((Component)addButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        JButton removeButton = new JButton(L10N.getLocalString("dlg.remove_btn", "Remove"));
        myPanel.add((Component)removeButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        JButton wizardButton = new JButton("Wizard");
        if (wizard) {
            NewProjectWizard thisGUI = this;
            myPanel.add((Component)wizardButton, gbc);
            wizardButton.addActionListener(evt -> {
                Project tempProject = new Project();
                for (int i1 = 0; i1 < this.analyzeModel.getSize(); ++i1) {
                    tempProject.addFile(this.analyzeModel.get(i1));
                }
                for (int i2 = 0; i2 < this.auxModel.getSize(); ++i2) {
                    tempProject.addAuxClasspathEntry(this.auxModel.get(i2));
                }
                EventQueue.invokeLater(() -> {
                    final SourceDirectoryWizard dialog = new SourceDirectoryWizard((Frame)new JFrame(), true, tempProject, thisGUI);
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            if (dialog.discover != null && dialog.discover.isAlive()) {
                                dialog.discover.interrupt();
                            }
                        }
                    });
                    dialog.setVisible(true);
                });
            });
        }
        gbc.insets = new Insets(0, 0, 0, 0);
        myPanel.add(Box.createGlue(), gbc);
        myPanel.setBorder(this.border);
        addButton.addActionListener(evt -> {
            this.chooser.setFileSelectionMode(fileSelectionMode);
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setApproveButtonText("Choose");
            this.chooser.setDialogTitle(dialogTitle);
            for (FileFilter ff : this.chooser.getChoosableFileFilters()) {
                this.chooser.removeChoosableFileFilter(ff);
            }
            this.chooser.setFileFilter(filter);
            if (this.chooser.showOpenDialog(this) == 0) {
                File[] selectedFiles;
                for (File selectedFile : selectedFiles = this.chooser.getSelectedFiles()) {
                    listModel.addElement(selectedFile.getAbsolutePath());
                }
                this.projectChanged = true;
                if (label.equals(L10N.getLocalString("dlg.class_jars_dirs_lbl", "Class archives and directories to analyze:"))) {
                    this.finishButton.setEnabled(true);
                }
            }
        });
        removeButton.addActionListener(evt -> {
            if (list.getSelectedValues().length > 0) {
                this.projectChanged = true;
            }
            for (Object i : list.getSelectedValues()) {
                listModel.removeElement(i);
            }
        });
        return myPanel;
    }

    private void loadAllPanels(JPanel mainPanel) {
        SwingUtilities.invokeLater(() -> {
            int numPanels = this.wizardComponents.length;
            for (int i1 = 0; i1 < numPanels; ++i1) {
                mainPanel.remove(this.wizardComponents[i1]);
            }
            for (int i2 = 0; i2 < numPanels; ++i2) {
                mainPanel.add(this.wizardComponents[i2]);
            }
            this.validate();
            this.repaint();
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        for (JComponent component : this.wizardComponents) {
            this.setFontSizeHelper(component.getComponents(), Driver.getFontSize());
        }
        this.pack();
        int width = super.getWidth();
        if (width < 600) {
            width = 600;
        }
        this.setSize(new Dimension(width, 500));
        this.setLocationRelativeTo(MainFrame.getInstance());
    }

    public void setSourceDirecs(DefaultListModel<String> foundModel) {
        for (int i = 0; i < foundModel.size(); ++i) {
            this.sourceModel.addElement(foundModel.getElementAt(i));
        }
    }
}

