/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.TreeSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class RedundantInterfaces
extends PreorderVisitor
implements Detector,
StatelessDetector {
    private final BugReporter bugReporter;

    public RedundantInterfaces(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        String superClassName = obj.getSuperclassName();
        if ("java.lang.Object".equals(superClassName)) {
            return;
        }
        String[] interfaceNames = obj.getInterfaceNames();
        if (interfaceNames == null || interfaceNames.length == 0) {
            return;
        }
        try {
            JavaClass superObj = obj.getSuperClass();
            TreeSet<String> redundantInfNames = new TreeSet<String>();
            for (String interfaceName : interfaceNames) {
                JavaClass inf;
                if ("java.io.Serializable".equals(interfaceName) || !superObj.instanceOf(inf = Repository.lookupClass((String)interfaceName))) continue;
                redundantInfNames.add(inf.getClassName());
            }
            if (!redundantInfNames.isEmpty()) {
                BugInstance bug = new BugInstance(this, "RI_REDUNDANT_INTERFACES", 3).addClass(obj);
                for (String redundantInfName : redundantInfNames) {
                    bug.addClass(redundantInfName).describe("INTERFACE_TYPE");
                }
                this.bugReporter.reportBug(bug);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    @Override
    public void report() {
    }
}

