/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import java.util.Iterator;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class IteratorIdioms
extends BytecodeScanningDetector
implements StatelessDetector {
    private static final String NEXT_NAME = "next";
    private static final String HAS_NEXT_NAME = "hasNext";
    private final ClassDescriptor iteratorDescriptor = DescriptorFactory.createClassDescriptor(Iterator.class);
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private boolean sawNoSuchElement;
    private boolean sawCall;
    private boolean shouldVisitCode;
    private boolean hasNextAlwaysReturnsTrue;
    private boolean sawBranch;

    public IteratorIdioms(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
        try {
            if (subtypes2.isSubtype(classContext.getClassDescriptor(), this.iteratorDescriptor)) {
                this.hasNextAlwaysReturnsTrue = false;
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
    }

    @Override
    public void visit(Method method) {
        if (method.isPublic() && (NEXT_NAME.equals(method.getName()) || HAS_NEXT_NAME.equals(method.getName())) && method.getArgumentTypes().length == 0) {
            this.shouldVisitCode = true;
            super.visit(method);
        } else {
            this.shouldVisitCode = false;
        }
    }

    @Override
    public void visit(Code code) {
        if (!this.shouldVisitCode) {
            return;
        }
        this.sawNoSuchElement = false;
        this.sawCall = false;
        this.sawBranch = false;
        super.visit(code);
        if (!this.sawNoSuchElement && NEXT_NAME.equals(this.getMethodName())) {
            BugInstance bug = new BugInstance(this, "IT_NO_SUCH_ELEMENT", this.sawCall ? 3 : 2);
            bug.addClassAndMethod(this);
            this.bugAccumulator.accumulateBug(bug, this);
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        if (this.hasNextAlwaysReturnsTrue) {
            this.bugAccumulator.clearBugs();
        } else {
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 187 && "java/util/NoSuchElementException".equals(this.getClassConstantOperand())) {
            this.sawNoSuchElement = true;
        } else if (seen == 183 || seen == 182 || seen == 185) {
            this.sawCall = true;
            String name = this.getNameConstantOperand().toLowerCase();
            if (name.indexOf(NEXT_NAME) >= 0 || name.indexOf("previous") >= 0) {
                this.sawNoSuchElement = true;
            }
        }
        if (seen == 172 && this.getPC() >= 1 && this.getPrevOpcode(1) == 4 && !this.sawBranch) {
            this.hasNextAlwaysReturnsTrue = true;
        }
        this.sawBranch |= IteratorIdioms.isBranch(seen);
    }
}

