/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.util.BootstrapMethodsUtil;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindOverridableMethodCall
extends OpcodeStackDetector {
    private final Map<XMethod, CallerInfo> callerConstructors = new HashMap<XMethod, CallerInfo>();
    private final Map<XMethod, CallerInfo> callerClones = new HashMap<XMethod, CallerInfo>();
    private final Map<XMethod, CallerInfo> callerReadObjects = new HashMap<XMethod, CallerInfo>();
    private final Map<XMethod, XMethod> callsToOverridable = new HashMap<XMethod, XMethod>();
    private final MultiMap<XMethod, XMethod> callerToCalleeMap = new MultiMap(ArrayList.class);
    private final MultiMap<XMethod, XMethod> calleeToCallerMap = new MultiMap(ArrayList.class);
    private final Map<Integer, CallerInfo> refCallerConstructors = new HashMap<Integer, CallerInfo>();
    private final Map<Integer, CallerInfo> refCallerClones = new HashMap<Integer, CallerInfo>();
    private final Map<Integer, CallerInfo> refCallerReadObjects = new HashMap<Integer, CallerInfo>();
    private final MultiMap<Integer, XMethod> refCalleeToCallerMap = new MultiMap(ArrayList.class);
    private static final String CONSTRUCTOR_BUG = "MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR";
    private static final String CLONE_BUG = "MC_OVERRIDABLE_METHOD_CALL_IN_CLONE";
    private static final String READ_OBJECT_BUG = "MC_OVERRIDABLE_METHOD_CALL_IN_READ_OBJECT";
    private final BugAccumulator bugAccumulator;

    public FindOverridableMethodCall(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        super.visit(obj);
        this.callerConstructors.clear();
        this.callerClones.clear();
        this.callerReadObjects.clear();
        this.callsToOverridable.clear();
        this.callerToCalleeMap.clear();
        this.calleeToCallerMap.clear();
        this.refCallerConstructors.clear();
        this.refCallerClones.clear();
        this.refCallerReadObjects.clear();
        this.refCalleeToCallerMap.clear();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods obj) {
        if (this.getXClass().isFinal()) {
            return;
        }
        for (int i = 0; i < obj.getBootstrapMethods().length; ++i) {
            Optional<Method> method;
            CallerInfo ctor = this.refCallerConstructors.get(i);
            CallerInfo clone = this.refCallerClones.get(i);
            CallerInfo readObject = this.refCallerReadObjects.get(i);
            Collection<XMethod> callers = this.refCalleeToCallerMap.get(i);
            if (ctor == null && clone == null && readObject == null && (callers == null || callers.isEmpty()) || (method = BootstrapMethodsUtil.getMethodFromBootstrap(obj, i, this.getConstantPool(), this.getThisClass())).isEmpty()) continue;
            XMethod xMethod = this.getXClass().findMethod(method.get().getName(), method.get().getSignature(), method.get().isStatic());
            if (ctor != null && this.checkAndRecordDirectCase(ctor.method, xMethod, CONSTRUCTOR_BUG, 3, ctor.sourceLine)) {
                this.checkAndRecordCallFromConstructor(ctor.method, xMethod, ctor.sourceLine);
            }
            if (clone != null && this.checkAndRecordDirectCase(clone.method, xMethod, CLONE_BUG, 2, clone.sourceLine)) {
                this.checkAndRecordCallFromClone(clone.method, xMethod, clone.sourceLine);
            }
            if (readObject != null && this.checkAndRecordDirectCase(readObject.method, xMethod, READ_OBJECT_BUG, 2, readObject.sourceLine)) {
                this.checkAndRecordCallFromReadObject(readObject.method, xMethod, readObject.sourceLine);
            }
            if (callers == null) continue;
            for (XMethod caller : callers) {
                if (xMethod.isPrivate() || xMethod.isFinal()) {
                    this.checkAndRecordCallBetweenNonOverridableMethods(caller, xMethod);
                    continue;
                }
                this.checkAndRecordCallToOverridable(caller, xMethod);
            }
        }
    }

    @Override
    public void visitAfter(JavaClass obj) {
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        if (this.getXClass().isFinal()) {
            return;
        }
        XMethod caller = this.getXMethod();
        if (seen == 186) {
            ConstantInvokeDynamic constDyn = (ConstantInvokeDynamic)this.getConstantRefOperand();
            if (this.stack.getStackDepth() == 0) {
                return;
            }
            item = this.stack.getStackItem(0);
            if (this.getNextOpcode() == 181) {
                return;
            }
            if (item.getRegisterNumber() == 0 && "<init>".equals(this.getMethodName())) {
                this.refCallerConstructors.put(constDyn.getBootstrapMethodAttrIndex(), new CallerInfo(caller, SourceLineAnnotation.fromVisitedInstruction(this)));
            } else if ("clone".equals(this.getMethodName()) && (("()" + this.getClassDescriptor().getSignature()).equals(this.getMethodSig()) || "()Ljava/lang/Object;".equals(this.getMethodSig())) && item.getReturnValueOf() != null && item.getReturnValueOf().equals(this.superClone(this.getXClass()))) {
                this.refCallerClones.put(constDyn.getBootstrapMethodAttrIndex(), new CallerInfo(caller, SourceLineAnnotation.fromVisitedInstruction(this)));
            } else if (this.isCurrentMethodReadObject()) {
                this.refCallerReadObjects.put(constDyn.getBootstrapMethodAttrIndex(), new CallerInfo(caller, SourceLineAnnotation.fromVisitedInstruction(this)));
            } else {
                this.refCalleeToCallerMap.add(constDyn.getBootstrapMethodAttrIndex(), caller);
            }
        }
        if (seen == 185 || seen == 182) {
            XMethod method = this.getXMethodOperand();
            if (method == null) {
                return;
            }
            item = this.stack.getStackItem(0);
            if (item.getRegisterNumber() == 0 && "<init>".equals(this.getMethodName())) {
                if (this.checkAndRecordDirectCase(caller, method, CONSTRUCTOR_BUG, 3, SourceLineAnnotation.fromVisitedInstruction(this))) {
                    this.checkAndRecordCallFromConstructor(caller, method, SourceLineAnnotation.fromVisitedInstruction(this));
                }
            } else if ("clone".equals(this.getMethodName()) && (("()" + this.getClassDescriptor().getSignature()).equals(this.getMethodSig()) || "()Ljava/lang/Object;".equals(this.getMethodSig())) && item.getReturnValueOf() != null && item.getReturnValueOf().equals(this.superClone(this.getXClass()))) {
                if (this.checkAndRecordDirectCase(caller, method, CLONE_BUG, 2, SourceLineAnnotation.fromVisitedInstruction(this))) {
                    this.checkAndRecordCallFromClone(caller, method, SourceLineAnnotation.fromVisitedInstruction(this));
                }
            } else if (this.isCurrentMethodReadObject()) {
                if (this.checkAndRecordDirectCase(caller, method, READ_OBJECT_BUG, 2, SourceLineAnnotation.fromVisitedInstruction(this))) {
                    this.checkAndRecordCallFromReadObject(caller, method, SourceLineAnnotation.fromVisitedInstruction(this));
                }
            } else if (item.getRegisterNumber() == 0 && (caller.isPrivate() || caller.isFinal())) {
                if (method.isPrivate() || method.isFinal()) {
                    this.checkAndRecordCallBetweenNonOverridableMethods(caller, method);
                } else {
                    this.checkAndRecordCallToOverridable(caller, method);
                }
            }
        }
    }

    private boolean isCurrentMethodReadObject() {
        return "readObject".equals(this.getMethodName()) && "(Ljava/io/ObjectInputStream;)V".equals(this.getMethodSig());
    }

    private XMethod superClone(XClass clazz) {
        ClassDescriptor superD = clazz.getSuperclassDescriptor();
        try {
            XClass xSuper = superD.getXClass();
            XMethod cloneMethod = xSuper.findMethod("clone", "()" + superD.getSignature(), false);
            if (cloneMethod == null) {
                cloneMethod = xSuper.findMethod("clone", "()Ljava/lang/Object;", false);
            }
            return cloneMethod;
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Could not find XClass object for " + String.valueOf(superD) + ".");
            return null;
        }
    }

    boolean checkAndRecordDirectCase(XMethod caller, XMethod method, String bugType, int priority, SourceLineAnnotation sourceLine) {
        if (!method.isPrivate() && !method.isFinal() && this.isSelfCall(method)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, bugType, priority).addClass(this).addMethod(caller).addCalledMethod(method), sourceLine);
            return false;
        }
        return true;
    }

    private boolean isSelfCall(XMethod method) {
        String className = this.getClassContext().getClassDescriptor().getDottedClassName();
        String methodClassName = method.getClassName();
        try {
            return className.equals(methodClassName) || Hierarchy.isSubtype(className, methodClassName);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
            return false;
        }
    }

    private void checkAndRecordCallFromConstructor(XMethod constructor, XMethod callee, SourceLineAnnotation sourceLine) {
        XMethod overridable = this.getIndirectlyCalledOverridable(callee);
        if (overridable != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, CONSTRUCTOR_BUG, 3).addClass(this).addMethod(constructor).addCalledMethod(overridable), sourceLine);
            return;
        }
        this.callerConstructors.put(callee, new CallerInfo(constructor, sourceLine));
    }

    private void checkAndRecordCallFromClone(XMethod clone, XMethod callee, SourceLineAnnotation sourceLine) {
        XMethod overridable = this.getIndirectlyCalledOverridable(callee);
        if (overridable != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, CLONE_BUG, 2).addClass(this).addMethod(clone).addCalledMethod(overridable), sourceLine);
            return;
        }
        this.callerClones.put(callee, new CallerInfo(clone, sourceLine));
    }

    private void checkAndRecordCallFromReadObject(XMethod readObject, XMethod callee, SourceLineAnnotation sourceLine) {
        XMethod overridable = this.getIndirectlyCalledOverridable(callee);
        if (overridable != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, READ_OBJECT_BUG, 2).addClass(this).addMethod(readObject).addCalledMethod(overridable), sourceLine);
            return;
        }
        this.callerReadObjects.put(callee, new CallerInfo(readObject, sourceLine));
    }

    private void checkAndRecordCallToOverridable(XMethod caller, XMethod overridable) {
        CallerInfo readObject;
        CallerInfo clone;
        CallerInfo constructor = this.getIndirectCallerConstructor(caller);
        if (constructor != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, CONSTRUCTOR_BUG, 3).addClassAndMethod(constructor.method).addCalledMethod(overridable), constructor.sourceLine);
        }
        if ((clone = this.getIndirectCallerClone(caller)) != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, CLONE_BUG, 2).addClassAndMethod(clone.method).addCalledMethod(overridable), clone.sourceLine);
        }
        if ((readObject = this.getIndirectCallerReadObject(caller)) != null && this.isSelfCall(overridable)) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, READ_OBJECT_BUG, 2).addClassAndMethod(readObject.method).addCalledMethod(overridable), readObject.sourceLine);
        }
        if ((constructor != null || clone != null || readObject != null) && this.isSelfCall(overridable)) {
            return;
        }
        this.callsToOverridable.put(caller, overridable);
    }

    private void checkAndRecordCallBetweenNonOverridableMethods(XMethod caller, XMethod callee) {
        XMethod overridable;
        CallerInfo constructor = this.getIndirectCallerConstructor(caller);
        CallerInfo clone = this.getIndirectCallerClone(caller);
        CallerInfo readObject = this.getIndirectCallerReadObject(caller);
        if ((constructor != null || clone != null || readObject != null) && (overridable = this.getIndirectlyCalledOverridable(callee)) != null) {
            if (constructor != null && this.isSelfCall(overridable)) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, CONSTRUCTOR_BUG, 3).addClassAndMethod(constructor.method).addCalledMethod(overridable), constructor.sourceLine);
            }
            if (clone != null && this.isSelfCall(overridable)) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, CLONE_BUG, 2).addClassAndMethod(clone.method).addCalledMethod(overridable), clone.sourceLine);
            }
            if (readObject != null && this.isSelfCall(overridable)) {
                this.bugAccumulator.accumulateBug(new BugInstance(this, READ_OBJECT_BUG, 2).addClassAndMethod(readObject.method).addCalledMethod(overridable), readObject.sourceLine);
            }
            return;
        }
        this.callerToCalleeMap.add(caller, callee);
        this.calleeToCallerMap.add(callee, caller);
    }

    private XMethod getIndirectlyCalledOverridable(XMethod caller) {
        return this.getIndirectlyCalledOverridable(caller, new HashSet<XMethod>());
    }

    private XMethod getIndirectlyCalledOverridable(XMethod caller, Set<XMethod> visited) {
        XMethod overridable = this.callsToOverridable.get(caller);
        if (overridable != null) {
            return overridable;
        }
        for (XMethod callee : this.callerToCalleeMap.get(caller)) {
            if (visited.contains(callee)) continue;
            visited.add(callee);
            overridable = this.getIndirectlyCalledOverridable(callee, visited);
            if (overridable == null) continue;
            return overridable;
        }
        return null;
    }

    private CallerInfo getIndirectCallerConstructor(XMethod callee) {
        return this.getIndirectCallerSpecial(callee, this.callerConstructors);
    }

    private CallerInfo getIndirectCallerClone(XMethod callee) {
        return this.getIndirectCallerSpecial(callee, this.callerClones);
    }

    private CallerInfo getIndirectCallerReadObject(XMethod callee) {
        return this.getIndirectCallerSpecial(callee, this.callerReadObjects);
    }

    private CallerInfo getIndirectCallerSpecial(XMethod callee, Map<XMethod, CallerInfo> map) {
        return this.getIndirectCallerSpecial(callee, map, new HashSet<XMethod>());
    }

    private CallerInfo getIndirectCallerSpecial(XMethod callee, Map<XMethod, CallerInfo> map, Set<XMethod> visited) {
        CallerInfo special = map.get(callee);
        if (special != null) {
            return special;
        }
        for (XMethod caller : this.calleeToCallerMap.get(callee)) {
            if (visited.contains(caller)) continue;
            visited.add(caller);
            special = this.getIndirectCallerSpecial(caller, map, visited);
            if (special == null) continue;
            return special;
        }
        return null;
    }

    private static class CallerInfo {
        XMethod method;
        SourceLineAnnotation sourceLine;

        CallerInfo(XMethod m, SourceLineAnnotation sl) {
            this.method = m;
            this.sourceLine = sl;
        }
    }
}

