/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindNakedNotify
extends BytecodeScanningDetector
implements StatelessDetector {
    private Stage stage = Stage.START;
    private final BugReporter bugReporter;
    boolean synchronizedMethod;
    private int notifyPC;

    public FindNakedNotify(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visit(Method obj) {
        int flags = obj.getAccessFlags();
        this.synchronizedMethod = (flags & 0x20) != 0;
    }

    @Override
    public void visit(Code obj) {
        this.stage = this.synchronizedMethod ? Stage.MONITOR_ENTERED : Stage.START;
        super.visit(obj);
        if (this.synchronizedMethod && this.stage == Stage.LOCK_LOADED) {
            this.bugReporter.reportBug(new BugInstance(this, "NN_NAKED_NOTIFY", 2).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
        }
    }

    @Override
    public void sawOpcode(int seen) {
        switch (this.stage.ordinal()) {
            case 0: {
                if (seen != 194) break;
                this.stage = Stage.MONITOR_ENTERED;
                break;
            }
            case 1: {
                if (!this.isRegisterLoad() && seen != 178 && seen != 180) break;
                this.stage = Stage.LOADED;
                break;
            }
            case 2: {
                if (this.isRegisterLoad() || seen == 178 || seen == 180) break;
                if (seen == 182 && ("notify".equals(this.getNameConstantOperand()) || "notifyAll".equals(this.getNameConstantOperand())) && "()V".equals(this.getSigConstantOperand())) {
                    this.stage = Stage.NOTIFY_CALLED;
                    this.notifyPC = this.getPC();
                    break;
                }
                this.stage = Stage.START;
                break;
            }
            case 3: {
                this.stage = Stage.LOCK_LOADED;
                break;
            }
            case 4: {
                if (seen == 195) {
                    this.bugReporter.reportBug(new BugInstance(this, "NN_NAKED_NOTIFY", 2).addClassAndMethod(this).addSourceLine(this, this.notifyPC));
                    this.stage = Stage.MONITOR_EXITED;
                    break;
                }
                this.stage = Stage.START;
                break;
            }
            case 5: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private static enum Stage {
        START,
        MONITOR_ENTERED,
        LOADED,
        NOTIFY_CALLED,
        LOCK_LOADED,
        MONITOR_EXITED;

    }
}

