/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bytecode.MemberUtils;
import edu.umd.cs.findbugs.detect.DumbMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DoInsideDoPrivileged
extends BytecodeScanningDetector {
    BugAccumulator bugAccumulator;
    private boolean isDoPrivileged = false;
    private boolean isDoPrivilegedDeprecated = false;

    public DoInsideDoPrivileged(BugReporter bugReporter) {
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visit(JavaClass obj) {
        this.isDoPrivilegedDeprecated = obj.getMajor() >= 61;
        this.isDoPrivileged = Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedAction") || Subtypes2.instanceOf(this.getDottedClassName(), "java.security.PrivilegedExceptionAction");
    }

    @Override
    public void visit(Code obj) {
        if (this.isDoPrivilegedDeprecated) {
            return;
        }
        if (this.isDoPrivileged && "run".equals(this.getMethodName())) {
            return;
        }
        if (this.getMethod().isPrivate()) {
            return;
        }
        if (DumbMethods.isTestMethod(this.getMethod())) {
            return;
        }
        super.visit(obj);
        this.bugAccumulator.reportAccumulatedBugs();
    }

    @Override
    public void sawOpcode(int seen) {
        String classOfConstructedClass;
        String className;
        if (seen == 182 && "setAccessible".equals(this.getNameConstantOperand()) && ("java.lang.reflect.Field".equals(className = this.getDottedClassConstantOperand()) || "java.lang.reflect.Method".equals(className))) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DP_DO_INSIDE_DO_PRIVILEGED", 3).addClassAndMethod(this).addCalledMethod(this), this);
        }
        if (seen == 187 && Subtypes2.instanceOf(classOfConstructedClass = this.getDottedClassConstantOperand(), "java.lang.ClassLoader") && !MemberUtils.isMainMethod(this.getMethod())) {
            this.bugAccumulator.accumulateBug(new BugInstance(this, "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED", 2).addClassAndMethod(this).addClass(classOfConstructedClass), this);
        }
    }
}

