/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.ICodeBaseIterator;
import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.IScannableCodeBase;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.classfile.impl.SingleFileCodeBaseEntry;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.NoSuchElementException;

public class SingleFileCodeBase
implements IScannableCodeBase {
    private final ICodeBaseLocator codeBaseLocator;
    private final String fileName;
    private boolean isAppCodeBase;
    private ICodeBase.Discovered howDiscovered;
    private long lastModifiedTime;
    private boolean resourceNameKnown;
    private String resourceName;

    public SingleFileCodeBase(ICodeBaseLocator codeBaseLocator, String fileName) {
        this.codeBaseLocator = codeBaseLocator;
        this.fileName = fileName;
        this.lastModifiedTime = new File(fileName).lastModified();
    }

    public String toString() {
        return this.fileName;
    }

    @Override
    public ICodeBaseLocator getCodeBaseLocator() {
        return this.codeBaseLocator;
    }

    @Override
    public boolean containsSourceFiles() throws InterruptedException {
        return false;
    }

    @Override
    public ICodeBaseIterator iterator() throws InterruptedException {
        return new ICodeBaseIterator(){
            boolean done = false;

            @Override
            public boolean hasNext() throws InterruptedException {
                return !this.done;
            }

            @Override
            public ICodeBaseEntry next() throws InterruptedException {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return new SingleFileCodeBaseEntry(SingleFileCodeBase.this);
            }
        };
    }

    @Override
    public ICodeBaseEntry lookupResource(String resourceName) {
        if (!resourceName.equals(this.getResourceName())) {
            return null;
        }
        return new SingleFileCodeBaseEntry(this);
    }

    @Override
    public void setApplicationCodeBase(boolean isAppCodeBase) {
        this.isAppCodeBase = isAppCodeBase;
    }

    @Override
    public boolean isApplicationCodeBase() {
        return this.isAppCodeBase;
    }

    @Override
    public void setHowDiscovered(ICodeBase.Discovered howDiscovered) {
        this.howDiscovered = howDiscovered;
    }

    @Override
    public ICodeBase.Discovered getHowDiscovered() {
        return this.howDiscovered;
    }

    @Override
    public void setLastModifiedTime(long lastModifiedTime) {
        if (lastModifiedTime > 0L && FindBugs.validTimestamp(lastModifiedTime)) {
            this.lastModifiedTime = lastModifiedTime;
        }
    }

    @Override
    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @Override
    public String getPathName() {
        return this.fileName;
    }

    InputStream openFile() throws IOException {
        return new BufferedInputStream(Files.newInputStream(Path.of(this.fileName, new String[0]), new OpenOption[0]));
    }

    @Override
    public void close() {
    }

    String getResourceName() {
        if (!this.resourceNameKnown) {
            try {
                this.resourceName = this.getClassDescriptor().toResourceName();
            }
            catch (Exception e) {
                this.resourceName = this.fileName;
            }
            this.resourceNameKnown = true;
        }
        return this.resourceName;
    }

    ClassDescriptor getClassDescriptor() throws ResourceNotFoundException, InvalidClassFileFormatException {
        ClassDescriptor classDescriptor;
        DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(Path.of(this.fileName, new String[0]), new OpenOption[0])));
        try {
            ClassParser classParser = new ClassParser(in, null, new SingleFileCodeBaseEntry(this));
            ClassNameAndSuperclassInfo.Builder builder = new ClassNameAndSuperclassInfo.Builder();
            classParser.parse(builder);
            classDescriptor = builder.build().getClassDescriptor();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceNotFoundException(this.fileName);
            }
        }
        in.close();
        return classDescriptor;
    }

    int getNumBytes() {
        File file = new File(this.fileName);
        return (int)file.length();
    }
}

