/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilder;
import edu.umd.cs.findbugs.ba.CFGBuilderFactory;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.MethodUnprofitableException;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.PruneInfeasibleExceptionEdges;
import edu.umd.cs.findbugs.ba.PruneUnconditionalExceptionThrowerEdges;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class CFGFactory
extends AnalysisFactory<CFG> {
    private static final boolean DEBUG_CFG = SystemProperties.getBoolean("classContext.debugCFG");

    public CFGFactory() {
        super("control flow graph factory", CFG.class);
    }

    @Override
    public CFG analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        boolean PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES;
        String methodId;
        MethodGen methodGen = analysisCache.getMethodAnalysis(MethodGen.class, descriptor);
        if (methodGen == null) {
            JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, descriptor.getClassDescriptor());
            Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
            JavaClassAndMethod javaClassAndMethod = new JavaClassAndMethod(jclass, method);
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportSkippedAnalysis(descriptor);
            throw new MethodUnprofitableException(javaClassAndMethod);
        }
        CFGBuilder cfgBuilder = CFGBuilderFactory.create(descriptor, methodGen);
        cfgBuilder.build();
        CFG cfg = cfgBuilder.getCFG();
        cfg.setFlag(16);
        analysisCache.eagerlyPutMethodAnalysis(CFG.class, descriptor, cfg);
        cfg.setMethodName(SignatureConverter.convertMethodSignature(methodGen));
        cfg.setMethodGen(methodGen);
        if (DEBUG_CFG) {
            methodId = methodGen.getClassName() + "." + methodGen.getName() + ":" + methodGen.getSignature();
            System.out.println("CC: getting refined CFG for " + methodId);
        }
        if (ClassContext.DEBUG) {
            methodId = methodGen.getClassName() + "." + methodGen.getName() + ":" + methodGen.getSignature();
            System.out.println("ClassContext: request to prune " + methodId);
        }
        boolean changed = false;
        boolean ASSUME_ASSERTIONS_ENABLED = true;
        if (ASSUME_ASSERTIONS_ENABLED) {
            LinkedList<Edge> edgesToRemove = new LinkedList<Edge>();
            Iterator<Object> i = cfg.edgeIterator();
            while (i.hasNext()) {
                Edge e = (Edge)i.next();
                if (e.getType() != 1) continue;
                try {
                    GETSTATIC getStatic;
                    BasicBlock source = (BasicBlock)e.getSource();
                    InstructionHandle last = source.getLastInstruction();
                    Instruction lastInstruction = last.getInstruction();
                    InstructionHandle prev = last.getPrev();
                    Instruction prevInstruction = prev.getInstruction();
                    if (!(prevInstruction instanceof GETSTATIC) || !(lastInstruction instanceof IFNE) || !"$assertionsDisabled".equals((getStatic = (GETSTATIC)prevInstruction).getFieldName(methodGen.getConstantPool())) || !"Z".equals(getStatic.getSignature(methodGen.getConstantPool()))) continue;
                    edgesToRemove.add(e);
                }
                catch (RuntimeException source) {}
            }
            if (!edgesToRemove.isEmpty()) {
                changed = true;
                for (Edge e : edgesToRemove) {
                    cfg.removeEdge(e);
                }
            }
        }
        cfg.setFlag(8);
        boolean PRUNE_INFEASIBLE_EXCEPTION_EDGES = AnalysisContext.currentAnalysisContext().getBoolProperty(0);
        if (PRUNE_INFEASIBLE_EXCEPTION_EDGES && !cfg.isFlagSet(1)) {
            try {
                TypeDataflow typeDataflow = analysisCache.getMethodAnalysis(TypeDataflow.class, descriptor);
                PruneInfeasibleExceptionEdges pruner = new PruneInfeasibleExceptionEdges(cfg, methodGen, typeDataflow);
                pruner.execute();
                changed = changed || pruner.wasCFGModified();
            }
            catch (MissingClassException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("unable to extract type analysis", e);
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
            }
        }
        cfg.setFlag(1);
        boolean bl = PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES = !AnalysisContext.currentAnalysisContext().getBoolProperty(1);
        if (PRUNE_UNCONDITIONAL_EXCEPTION_THROWER_EDGES && !cfg.isFlagSet(2)) {
            try {
                JavaClass jclass = analysisCache.getClassAnalysis(JavaClass.class, descriptor.getClassDescriptor());
                Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
                ConstantPoolGen cpg = analysisCache.getClassAnalysis(ConstantPoolGen.class, descriptor.getClassDescriptor());
                TypeDataflow typeDataflow = analysisCache.getMethodAnalysis(TypeDataflow.class, descriptor);
                PruneUnconditionalExceptionThrowerEdges pruner = new PruneUnconditionalExceptionThrowerEdges(jclass, method, methodGen, cfg, cpg, typeDataflow, AnalysisContext.currentAnalysisContext());
                pruner.execute();
                if (pruner.wasCFGModified()) {
                    changed = true;
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Error pruning normal return edges for unconditionally throwing methods for " + String.valueOf(descriptor), e);
            }
        }
        cfg.setFlag(2);
        cfg.setFlag(4);
        cfg.clearFlag(16);
        if (changed) {
            DepthFirstSearch dfs = new DepthFirstSearch(cfg);
            dfs.search();
            Collection unreachable = dfs.unvisitedVertices();
            if (!unreachable.isEmpty()) {
                if (DEBUG_CFG) {
                    System.out.println("Unreachable blocks");
                }
                for (BasicBlock b : unreachable) {
                    if (DEBUG_CFG) {
                        System.out.println(" removing " + String.valueOf(b));
                    }
                    cfg.removeVertex(b);
                }
            }
            Global.getAnalysisCache().purgeMethodAnalyses(descriptor);
        }
        return cfg;
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(CFG.class, this);
    }
}

