/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.InvalidClassFileFormatException;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.analysis.ClassNameAndSuperclassInfo;
import edu.umd.cs.findbugs.classfile.engine.ClassParser;
import edu.umd.cs.findbugs.classfile.engine.ClassParserInterface;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

@Deprecated
public class ClassParserUsingBCEL
implements ClassParserInterface {
    private final JavaClass javaClass;
    private final String slashedClassName;
    private final ClassDescriptor expectedClassDescriptor;
    private final ICodeBaseEntry codeBaseEntry;

    public ClassParserUsingBCEL(JavaClass javaClass, @CheckForNull ClassDescriptor expectedClassDescriptor, ICodeBaseEntry codeBaseEntry) {
        this.javaClass = javaClass;
        this.slashedClassName = ClassName.toSlashedClassName(javaClass.getClassName());
        this.expectedClassDescriptor = expectedClassDescriptor;
        this.codeBaseEntry = codeBaseEntry;
    }

    @Override
    public void parse(ClassNameAndSuperclassInfo.Builder builder) throws InvalidClassFileFormatException {
        ClassDescriptor[] allInterfaceDescriptiors;
        builder.setCodeBaseEntry(this.codeBaseEntry);
        builder.setAccessFlags(this.javaClass.getAccessFlags());
        ClassDescriptor classDescriptor = DescriptorFactory.createClassDescriptorFromDottedClassName(this.javaClass.getClassName());
        if (this.expectedClassDescriptor != null && this.expectedClassDescriptor.equals(classDescriptor)) {
            throw new InvalidClassFileFormatException("Expected " + String.valueOf(this.expectedClassDescriptor), classDescriptor, this.codeBaseEntry);
        }
        builder.setClassDescriptor(classDescriptor);
        builder.setSuperclassDescriptor(DescriptorFactory.createClassDescriptorFromDottedClassName(this.javaClass.getSuperclassName()));
        String[] allInterfaces = this.javaClass.getInterfaceNames();
        if (allInterfaces.length == 0) {
            allInterfaceDescriptiors = ClassDescriptor.EMPTY_ARRAY;
        } else {
            allInterfaceDescriptiors = new ClassDescriptor[allInterfaces.length];
            for (int i = 0; i < allInterfaces.length; ++i) {
                allInterfaceDescriptiors[i] = DescriptorFactory.createClassDescriptorFromDottedClassName(allInterfaces[i]);
            }
        }
        builder.setInterfaceDescriptorList(allInterfaceDescriptiors);
    }

    @Override
    public void parse(ClassInfo.Builder builder) throws InvalidClassFileFormatException {
        this.parse((ClassNameAndSuperclassInfo.Builder)builder);
        final TreeSet referencedClassSet = new TreeSet();
        this.javaClass.accept((Visitor)new AnnotationVisitor(){

            @Override
            public void visit(ConstantClass obj) {
                String className = obj.getBytes(ClassParserUsingBCEL.this.javaClass.getConstantPool());
                if (className.indexOf(91) >= 0) {
                    ClassParser.extractReferencedClassesFromSignature(referencedClassSet, className);
                } else if (ClassName.isValidClassName(className)) {
                    referencedClassSet.add(DescriptorFactory.instance().getClassDescriptor(className));
                }
            }

            @Override
            public void visit(ConstantNameAndType obj) {
                String signature = obj.getSignature(ClassParserUsingBCEL.this.javaClass.getConstantPool());
                ClassParser.extractReferencedClassesFromSignature(referencedClassSet, signature);
            }
        });
    }

    protected FieldDescriptor parseField(Field obj) {
        return new FieldDescriptor(this.slashedClassName, obj.getName(), obj.getSignature(), obj.isStatic());
    }

    protected MethodDescriptor parseMethod(Method obj) {
        return new MethodDescriptor(this.slashedClassName, obj.getName(), obj.getSignature(), obj.isStatic());
    }
}

