/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;

public class AvailableLoad
implements Comparable<AvailableLoad> {
    private final ValueNumber reference;
    private final XField field;

    public AvailableLoad(XField staticField) {
        this.reference = null;
        this.field = staticField;
    }

    public AvailableLoad(ValueNumber reference, XField field) {
        if (reference == null) {
            throw new IllegalArgumentException();
        }
        this.reference = reference;
        this.field = field;
    }

    public ValueNumber getReference() {
        return this.reference;
    }

    public boolean matchesReference(ValueNumber v) {
        if (v == this.reference) {
            return true;
        }
        if (this.reference == null) {
            return false;
        }
        return this.reference.equals(v);
    }

    public XField getField() {
        return this.field;
    }

    @Override
    public int compareTo(AvailableLoad other) {
        int cmp = this.field.compareTo(other.field);
        if (cmp != 0) {
            return cmp;
        }
        if (this.reference == other.reference) {
            return 0;
        }
        if (this.reference == null) {
            return -1;
        }
        if (other.reference == null) {
            return 1;
        }
        return this.reference.compareTo(other.reference);
    }

    public int hashCode() {
        return (this.reference == null ? 0 : this.reference.hashCode()) ^ this.field.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailableLoad other = (AvailableLoad)o;
        return (this.reference == other.reference || this.reference != null && other.reference != null && this.reference.equals(other.reference)) && this.field.equals(other.field);
    }

    public String toString() {
        return (String)(this.reference == null ? "" : this.reference.getNumber() + ".") + String.valueOf(this.field);
    }
}

