/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysisFeatures;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.npe.LocationWhereValueBecomesNull;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReturnInstruction;
import org.apache.bcel.generic.Type;

public class IsNullValueAnalysis
extends FrameDataflowAnalysis<IsNullValue, IsNullValueFrame>
implements EdgeTypes,
IsNullValueAnalysisFeatures {
    static final boolean DEBUG = SystemProperties.getBoolean("inva.debug");
    private final MethodGen methodGen;
    private final IsNullValueFrameModelingVisitor visitor;
    private final ValueNumberDataflow vnaDataflow;
    private final CFG cfg;
    private final Set<LocationWhereValueBecomesNull> locationWhereValueBecomesNullSet;
    private final boolean trackValueNumbers = AnalysisContext.currentAnalysisContext().getBoolProperty(6);
    private IsNullValueFrame lastFrame;
    private IsNullValueFrame instanceOfFrame;
    private IsNullValueFrame cachedEntryFact;
    private JavaClassAndMethod classAndMethod;
    @CheckForNull
    private final PointerEqualityCheck pointerEqualityCheck;
    private static final BitSet nullComparisonInstructionSet;

    public IsNullValueAnalysis(MethodDescriptor descriptor, MethodGen methodGen, CFG cfg, ValueNumberDataflow vnaDataflow, TypeDataflow typeDataflow, DepthFirstSearch dfs, AssertionMethods assertionMethods) {
        super(dfs);
        this.methodGen = methodGen;
        this.visitor = new IsNullValueFrameModelingVisitor(methodGen.getConstantPool(), assertionMethods, vnaDataflow, typeDataflow, this.trackValueNumbers);
        this.vnaDataflow = vnaDataflow;
        this.cfg = cfg;
        this.locationWhereValueBecomesNullSet = new HashSet<LocationWhereValueBecomesNull>();
        this.pointerEqualityCheck = IsNullValueAnalysis.getForPointerEqualityCheck(cfg, vnaDataflow);
        if (DEBUG) {
            System.out.println("IsNullValueAnalysis for " + methodGen.getClassName() + "." + methodGen.getName() + " : " + methodGen.getSignature());
        }
    }

    @CheckForNull
    public static PointerEqualityCheck getForPointerEqualityCheck(CFG cfg, ValueNumberDataflow vna) {
        PointerEqualityCheckState state = PointerEqualityCheckState.INIT;
        int target = Integer.MAX_VALUE;
        Location test = null;
        for (Location loc : cfg.orderedLocations()) {
            Instruction ins = loc.getHandle().getInstruction();
            switch (state.ordinal()) {
                case 0: {
                    assert (ins instanceof NOP);
                    state = PointerEqualityCheckState.START;
                    break;
                }
                case 1: {
                    if (ins instanceof ALOAD) {
                        state = PointerEqualityCheckState.SAW1;
                        break;
                    }
                    return null;
                }
                case 2: {
                    if (ins instanceof ALOAD) {
                        state = PointerEqualityCheckState.SAW2;
                        break;
                    }
                    return null;
                }
                case 3: {
                    if (ins instanceof IF_ACMPNE) {
                        state = PointerEqualityCheckState.IFEQUAL;
                        target = ((IF_ACMPNE)ins).getIndex() + loc.getHandle().getPosition();
                        test = loc;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (ins instanceof ReturnInstruction || ins instanceof ATHROW) {
                        state = PointerEqualityCheckState.IFNOTEQUAL;
                        break;
                    }
                    if (!(ins instanceof BranchInstruction)) break;
                    return null;
                }
                case 5: {
                    if (loc.getHandle().getPosition() == target) {
                        try {
                            ValueNumberFrame vnaFrame = (ValueNumberFrame)vna.getFactAtLocation(test);
                            return new PointerEqualityCheck((ValueNumber)vnaFrame.getStackValue(0), (ValueNumber)vnaFrame.getStackValue(1), target);
                        }
                        catch (DataflowAnalysisException e) {
                            return null;
                        }
                    }
                    return null;
                }
            }
        }
        return null;
    }

    @CheckForNull
    private ValueNumber getKnownNonnullDueToPointerDisequality(ValueNumber knownNull, int pc) {
        if (this.pointerEqualityCheck == null || pc < this.pointerEqualityCheck.firstValuePC) {
            return null;
        }
        if (this.pointerEqualityCheck.reg1.equals(knownNull)) {
            return this.pointerEqualityCheck.reg2;
        }
        if (this.pointerEqualityCheck.reg2.equals(knownNull)) {
            return this.pointerEqualityCheck.reg1;
        }
        return null;
    }

    public void setClassAndMethod(JavaClassAndMethod classAndMethod) {
        this.classAndMethod = classAndMethod;
    }

    public JavaClassAndMethod getClassAndMethod() {
        return this.classAndMethod;
    }

    @Override
    public IsNullValueFrame createFact() {
        return new IsNullValueFrame(this.methodGen.getMaxLocals(), this.trackValueNumbers);
    }

    @Override
    public void initEntryFact(IsNullValueFrame result) {
        if (this.cachedEntryFact == null) {
            this.cachedEntryFact = this.createFact();
            this.cachedEntryFact.setValid();
            int numLocals = this.methodGen.getMaxLocals();
            boolean instanceMethod = !this.methodGen.isStatic();
            XMethod xm = XFactory.createXMethod(this.methodGen.getClassName(), this.methodGen.getName(), this.methodGen.getSignature(), this.methodGen.isStatic());
            TypeQualifierNullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
            int paramShift = instanceMethod ? 1 : 0;
            Type[] argumentTypes = this.methodGen.getArgumentTypes();
            for (int i = 0; i < numLocals; ++i) {
                this.cachedEntryFact.setValue(i, IsNullValue.nonReportingNotNullValue());
            }
            if (paramShift == 1) {
                this.cachedEntryFact.setValue(0, IsNullValue.nonNullValue());
            }
            int slot = paramShift;
            for (int paramIndex = 0; paramIndex < argumentTypes.length; ++paramIndex) {
                XMethodParameter methodParameter = new XMethodParameter(xm, paramIndex);
                NullnessAnnotation n = db.getResolvedAnnotation(methodParameter, false);
                IsNullValue value = n == NullnessAnnotation.CHECK_FOR_NULL ? IsNullValue.parameterMarkedAsMightBeNull(methodParameter) : (n == NullnessAnnotation.NONNULL ? IsNullValue.parameterMarkedAsNonnull(methodParameter) : IsNullValue.nonReportingNotNullValue());
                this.cachedEntryFact.setValue(slot, value);
                slot += argumentTypes[paramIndex].getSize();
            }
        }
        this.copy(this.cachedEntryFact, result);
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, IsNullValueFrame start, IsNullValueFrame result) throws DataflowAnalysisException {
        ValueNumberFrame vnaFrameAfter;
        this.startTransfer();
        super.transfer(basicBlock, end, start, result);
        this.endTransfer(basicBlock, end, result);
        if (end == null && !(vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(Location.getLastLocation(basicBlock))).isTop()) {
            result.cleanStaleKnowledge(vnaFrameAfter);
        }
    }

    public void startTransfer() {
        this.lastFrame = null;
        this.instanceOfFrame = null;
    }

    public void endTransfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, IsNullValueFrame result) throws DataflowAnalysisException {
        if (end == null) {
            if (this.lastFrame == null) {
                result.setDecision(null);
            } else {
                IsNullConditionDecision decision = this.getDecision(basicBlock, this.lastFrame);
                result.setDecision(decision);
            }
        }
        this.lastFrame = null;
        this.instanceOfFrame = null;
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, IsNullValueFrame fact) throws DataflowAnalysisException {
        if (!fact.isValid()) {
            return;
        }
        if (handle == basicBlock.getLastInstruction()) {
            this.lastFrame = this.createFact();
            this.lastFrame.copyFrom(fact);
        }
        if (handle.getInstruction().getOpcode() == 193) {
            this.instanceOfFrame = this.createFact();
            this.instanceOfFrame.copyFrom(fact);
        }
        this.visitor.setFrameAndLocation(fact, new Location(handle, basicBlock));
        Instruction ins = handle.getInstruction();
        this.visitor.analyzeInstruction(ins);
        if (!fact.isValid()) {
            return;
        }
        int numProduced = ins.produceStack(this.methodGen.getConstantPool());
        if (numProduced == -2) {
            throw new DataflowAnalysisException("Unpredictable stack production", this.methodGen, handle);
        }
        int start = fact.getNumSlots() - numProduced;
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
        if (!vnaFrameAfter.isValid()) {
            assert (false) : "Invalid VNA after location " + String.valueOf(location) + " in " + SignatureConverter.convertMethodSignature(this.methodGen);
            return;
        }
        for (int i = start; i < fact.getNumSlots(); ++i) {
            ValueNumber value = (ValueNumber)vnaFrameAfter.getValue(i);
            IsNullValue isNullValue = (IsNullValue)fact.getValue(i);
            for (int j = 0; j < start; ++j) {
                ValueNumber otherValue = (ValueNumber)vnaFrameAfter.getValue(j);
                if (!value.equals(otherValue)) continue;
                fact.setValue(j, isNullValue);
            }
        }
        if (this.visitor.getSlotContainingNewNullValue() >= 0) {
            ValueNumber newNullValue = (ValueNumber)vnaFrameAfter.getValue(this.visitor.getSlotContainingNewNullValue());
            this.addLocationWhereValueBecomesNull(new LocationWhereValueBecomesNull(location, newNullValue));
        }
    }

    @Override
    public void meetInto(IsNullValueFrame fact, Edge edge, IsNullValueFrame result) throws DataflowAnalysisException {
        this.meetInto(fact, edge, result, true);
    }

    public void meetInto(IsNullValueFrame fact, Edge edge, IsNullValueFrame result, boolean propagatePhiNodeInformation) throws DataflowAnalysisException {
        if (fact.isValid()) {
            BasicBlock destBlock;
            IsNullValueFrame tmpFact = null;
            if (!NO_SPLIT_DOWNGRADE_NSP && !edge.isExceptionEdge() && this.cfg.getNumNonExceptionSucessors((BasicBlock)edge.getSource()) > 1) {
                tmpFact = this.modifyFrame(fact, null);
                tmpFact.downgradeOnControlSplit();
            }
            if (!NO_SWITCH_DEFAULT_AS_EXCEPTION && edge.getType() == 3) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.toExceptionValues();
            }
            if ((destBlock = (BasicBlock)edge.getTarget()).isExceptionHandler()) {
                String catchClass;
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.clearStack();
                CodeExceptionGen handler = destBlock.getExceptionGen();
                ObjectType catchType = handler.getCatchType();
                if (catchType != null && ("java.lang.CloneNotSupportedException".equals(catchClass = catchType.getClassName()) || "java.lang.InterruptedException".equals(catchClass))) {
                    for (int i = 0; i < tmpFact.getNumSlots(); ++i) {
                        IsNullValue value = (IsNullValue)tmpFact.getValue(i);
                        if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                        tmpFact.setValue(i, IsNullValue.nullOnComplexPathValue());
                    }
                }
                tmpFact.toExceptionValues();
                tmpFact.pushValue(IsNullValue.nonNullValue());
            } else {
                IsNullValueFrame resultFact;
                IsNullConditionDecision decision;
                int edgeType = edge.getType();
                BasicBlock sourceBlock = (BasicBlock)edge.getSource();
                BasicBlock targetBlock = (BasicBlock)edge.getTarget();
                ValueNumberFrame targetVnaFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact(destBlock);
                ValueNumberFrame sourceVnaFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact(sourceBlock);
                assert (targetVnaFrame != null);
                if ((edgeType == 1 || edgeType == 0) && (decision = (resultFact = (IsNullValueFrame)this.getResultFact(sourceBlock)).getDecision()) != null) {
                    if (!decision.isEdgeFeasible(edgeType)) {
                        tmpFact = this.createFact();
                        tmpFact.setTop();
                    } else {
                        ValueNumber valueTested = decision.getValue();
                        if (valueTested != null) {
                            if (DEBUG) {
                                System.out.println("Updating edge information for " + String.valueOf(valueTested));
                            }
                            Location atIf = new Location(sourceBlock.getLastInstruction(), sourceBlock);
                            ValueNumberFrame prevVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atIf);
                            IsNullValue decisionValue = decision.getDecision(edgeType);
                            if (decisionValue != null) {
                                if (DEBUG) {
                                    System.out.println("Set decision information");
                                    System.out.println("  " + String.valueOf(valueTested) + " becomes " + String.valueOf(decisionValue));
                                    System.out.println("  at " + targetBlock.getFirstInstruction().getPosition());
                                    System.out.println("  prev available loads: " + prevVnaFrame.availableLoadMapAsString());
                                    System.out.println("  target available loads: " + targetVnaFrame.availableLoadMapAsString());
                                }
                                tmpFact = this.replaceValues(fact, tmpFact, valueTested, prevVnaFrame, targetVnaFrame, decisionValue);
                                if (decisionValue.isDefinitelyNull()) {
                                    this.addLocationWhereValueBecomesNull(new LocationWhereValueBecomesNull(atIf, valueTested));
                                    ValueNumber knownNonnull = this.getKnownNonnullDueToPointerDisequality(valueTested, atIf.getHandle().getPosition());
                                    if (knownNonnull != null) {
                                        tmpFact = this.replaceValues(fact, tmpFact, knownNonnull, prevVnaFrame, targetVnaFrame, IsNullValue.checkedNonNullValue());
                                    }
                                }
                            }
                        }
                    }
                }
                if (sourceBlock.isNullCheck() && edgeType == 0) {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact(destBlock);
                    if (vnaFrame == null) {
                        throw new IllegalStateException("no vna frame at block entry?");
                    }
                    Instruction firstInDest = ((BasicBlock)edge.getTarget()).getFirstInstruction().getInstruction();
                    IsNullValue instance = (IsNullValue)fact.getInstance(firstInDest, this.methodGen.getConstantPool());
                    if (instance.isDefinitelyNull()) {
                        tmpFact = this.createFact();
                        tmpFact.setTop();
                    } else if (!instance.isDefinitelyNotNull()) {
                        InstructionHandle kaBoomLocation = targetBlock.getFirstInstruction();
                        ValueNumber replaceMe = (ValueNumber)vnaFrame.getInstance(firstInDest, this.methodGen.getConstantPool());
                        IsNullValue noKaboomNonNullValue = IsNullValue.noKaboomNonNullValue(new Location(kaBoomLocation, targetBlock));
                        if (DEBUG) {
                            System.out.println("Start vna fact: " + String.valueOf(vnaFrame));
                            System.out.println("inva fact: " + String.valueOf(fact));
                            System.out.println("\nGenerated NoKaboom value for location " + String.valueOf(kaBoomLocation));
                            System.out.println("Dereferenced " + String.valueOf(instance));
                            System.out.println("On fall through from source block " + String.valueOf(sourceBlock));
                        }
                        tmpFact = this.replaceValues(fact, tmpFact, replaceMe, vnaFrame, targetVnaFrame, noKaboomNonNullValue);
                    }
                }
                if (propagatePhiNodeInformation && targetVnaFrame.phiNodeForLoads) {
                    if (DEBUG) {
                        System.out.println("Is phi node for loads");
                    }
                    for (ValueNumber v : fact.getKnownValues()) {
                        ValueNumber[] matchingValueNumbers;
                        AvailableLoad loadForV = sourceVnaFrame.getLoad(v);
                        if (DEBUG) {
                            System.out.println("  " + String.valueOf(v) + " for " + String.valueOf(loadForV));
                        }
                        if (loadForV == null || (matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV)) == null) continue;
                        for (ValueNumber v2 : matchingValueNumbers) {
                            tmpFact = this.modifyFrame(fact, tmpFact);
                            tmpFact.useNewValueNumberForLoad(v, v2);
                            if (!DEBUG) continue;
                            System.out.println("For " + String.valueOf(loadForV) + " switch from " + String.valueOf(v) + " to " + String.valueOf(v2));
                        }
                    }
                }
            }
            if (tmpFact != null) {
                fact = tmpFact;
            }
        }
        if (DEBUG) {
            System.out.println("At " + String.valueOf(edge));
            System.out.println("Merge " + String.valueOf(fact) + " into " + String.valueOf(result));
        }
        this.mergeInto(fact, result);
        if (DEBUG) {
            System.out.println("getting " + String.valueOf(result));
        }
    }

    @Override
    protected void mergeInto(IsNullValueFrame other, IsNullValueFrame result) throws DataflowAnalysisException {
        if (other.isTop()) {
            return;
        }
        if (result.isTop()) {
            result.copyFrom(other);
            return;
        }
        super.mergeInto(other, result);
        if (this.trackValueNumbers) {
            result.mergeKnownValuesWith(other);
        }
    }

    @Override
    public void startIteration() {
        this.locationWhereValueBecomesNullSet.clear();
    }

    public void addLocationWhereValueBecomesNull(LocationWhereValueBecomesNull locationWhereValueBecomesNull) {
        this.locationWhereValueBecomesNullSet.add(locationWhereValueBecomesNull);
    }

    public Set<LocationWhereValueBecomesNull> getLocationWhereValueBecomesNullSet() {
        return this.locationWhereValueBecomesNullSet;
    }

    @Override
    protected void mergeValues(IsNullValueFrame otherFrame, IsNullValueFrame resultFrame, int slot) throws DataflowAnalysisException {
        IsNullValue value = IsNullValue.merge((IsNullValue)resultFrame.getValue(slot), (IsNullValue)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    private IsNullConditionDecision getDecision(BasicBlock basicBlock, IsNullValueFrame lastFrame) throws DataflowAnalysisException {
        assert (lastFrame != null);
        InstructionHandle lastInSourceHandle = basicBlock.getLastInstruction();
        if (lastInSourceHandle == null) {
            return null;
        }
        short lastInSourceOpcode = lastInSourceHandle.getInstruction().getOpcode();
        if (lastInSourceOpcode == 153 || lastInSourceOpcode == 154) {
            InstructionHandle prev = lastInSourceHandle.getPrev();
            if (prev == null) {
                return null;
            }
            short secondToLastOpcode = prev.getInstruction().getOpcode();
            if (secondToLastOpcode != 193) {
                return null;
            }
            if (this.instanceOfFrame == null) {
                return null;
            }
            IsNullValue tos = (IsNullValue)this.instanceOfFrame.getTopValue();
            boolean isNotInstanceOf = lastInSourceOpcode != 154;
            Location atInstanceOf = new Location(prev, basicBlock);
            ValueNumberFrame instanceOfVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atInstanceOf);
            IsNullValue ifcmpDecision = null;
            IsNullValue fallThroughDecision = null;
            if (tos.isDefinitelyNull()) {
                if (isNotInstanceOf) {
                    ifcmpDecision = tos;
                } else {
                    fallThroughDecision = tos;
                }
            } else {
                if (tos.isDefinitelyNotNull()) {
                    return null;
                }
                ifcmpDecision = isNotInstanceOf ? tos : IsNullValue.pathSensitiveNonNullValue();
                IsNullValue isNullValue = fallThroughDecision = isNotInstanceOf ? IsNullValue.pathSensitiveNonNullValue() : tos;
            }
            if (DEBUG) {
                System.out.println("Checking..." + String.valueOf(tos) + " -> " + String.valueOf(ifcmpDecision) + " or " + String.valueOf(fallThroughDecision));
            }
            return new IsNullConditionDecision((ValueNumber)instanceOfVnaFrame.getTopValue(), ifcmpDecision, fallThroughDecision);
        }
        if (!nullComparisonInstructionSet.get(lastInSourceOpcode)) {
            return null;
        }
        Location atIf = new Location(lastInSourceHandle, basicBlock);
        ValueNumberFrame prevVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atIf);
        switch (lastInSourceOpcode) {
            case 198: 
            case 199: {
                IsNullValue tos = (IsNullValue)lastFrame.getTopValue();
                boolean ifnull = lastInSourceOpcode == 198;
                ValueNumber prevTopValue = (ValueNumber)prevVnaFrame.getTopValue();
                return this.handleIfNull(tos, prevTopValue, ifnull);
            }
            case 165: 
            case 166: {
                ValueNumber value;
                IsNullValue tos = (IsNullValue)lastFrame.getStackValue(0);
                IsNullValue nextToTos = (IsNullValue)lastFrame.getStackValue(1);
                boolean tosNull = tos.isDefinitelyNull();
                boolean nextToTosNull = nextToTos.isDefinitelyNull();
                boolean cmpeq = lastInSourceOpcode == 165;
                IsNullValue ifcmpDecision = null;
                IsNullValue fallThroughDecision = null;
                if (tosNull && nextToTosNull) {
                    value = null;
                    if (cmpeq) {
                        ifcmpDecision = IsNullValue.pathSensitiveNullValue();
                    } else {
                        fallThroughDecision = IsNullValue.pathSensitiveNullValue();
                    }
                } else {
                    if (tosNull || nextToTosNull) {
                        if (tosNull) {
                            return this.handleIfNull(nextToTos, (ValueNumber)prevVnaFrame.getStackValue(1), cmpeq);
                        }
                        assert (nextToTosNull);
                        return this.handleIfNull(tos, (ValueNumber)prevVnaFrame.getStackValue(0), cmpeq);
                    }
                    if (tos.isDefinitelyNotNull() && !nextToTos.isDefinitelyNotNull()) {
                        value = (ValueNumber)prevVnaFrame.getStackValue(1);
                        if (cmpeq) {
                            ifcmpDecision = tos;
                            fallThroughDecision = nextToTos;
                        } else {
                            fallThroughDecision = tos;
                            ifcmpDecision = nextToTos;
                        }
                    } else if (!tos.isDefinitelyNotNull() && nextToTos.isDefinitelyNotNull()) {
                        value = (ValueNumber)prevVnaFrame.getStackValue(0);
                        if (cmpeq) {
                            ifcmpDecision = nextToTos;
                            fallThroughDecision = tos;
                        } else {
                            fallThroughDecision = nextToTos;
                            ifcmpDecision = tos;
                        }
                    } else {
                        return null;
                    }
                }
                return new IsNullConditionDecision(value, ifcmpDecision, fallThroughDecision);
            }
        }
        throw new IllegalStateException();
    }

    private IsNullConditionDecision handleIfNull(IsNullValue tos, ValueNumber prevTopValue, boolean ifnull) {
        IsNullValue ifcmpDecision = null;
        IsNullValue fallThroughDecision = null;
        if (tos.isDefinitelyNull()) {
            if (ifnull) {
                ifcmpDecision = IsNullValue.pathSensitiveNullValue();
            } else {
                fallThroughDecision = IsNullValue.pathSensitiveNullValue();
            }
        } else if (tos.isDefinitelyNotNull()) {
            if (ifnull) {
                fallThroughDecision = tos.wouldHaveBeenAKaboom() ? tos : IsNullValue.pathSensitiveNonNullValue();
            } else {
                ifcmpDecision = tos.wouldHaveBeenAKaboom() ? tos : IsNullValue.pathSensitiveNonNullValue();
            }
        } else {
            ifcmpDecision = ifnull ? IsNullValue.pathSensitiveNullValue() : IsNullValue.pathSensitiveNonNullValue();
            fallThroughDecision = ifnull ? IsNullValue.pathSensitiveNonNullValue() : IsNullValue.pathSensitiveNullValue();
        }
        return new IsNullConditionDecision(prevTopValue, ifcmpDecision, fallThroughDecision);
    }

    private IsNullValueFrame replaceValues(IsNullValueFrame origFrame, IsNullValueFrame frame, ValueNumber replaceMe, ValueNumberFrame prevVnaFrame, ValueNumberFrame targetVnaFrame, IsNullValue replacementValue) {
        if (!targetVnaFrame.isValid()) {
            throw new IllegalArgumentException("Invalid frame in " + this.methodGen.getClassName() + "." + this.methodGen.getName() + " : " + this.methodGen.getSignature());
        }
        frame = this.modifyFrame(origFrame, frame);
        assert (frame.getNumSlots() == targetVnaFrame.getNumSlots()) : " frame has " + frame.getNumSlots() + ", target has " + targetVnaFrame.getNumSlots() + " in  " + String.valueOf(this.classAndMethod);
        int targetNumSlots = targetVnaFrame.getNumSlots();
        int prefixNumSlots = Math.min(frame.getNumSlots(), prevVnaFrame.getNumSlots());
        if (this.trackValueNumbers) {
            ValueNumber[] matchingValueNumbers;
            AvailableLoad loadForV = prevVnaFrame.getLoad(replaceMe);
            if (DEBUG && loadForV != null) {
                System.out.println("For " + String.valueOf(replaceMe) + " availableLoad is " + String.valueOf(loadForV));
                matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV);
                if (matchingValueNumbers != null) {
                    for (ValueNumber v2 : matchingValueNumbers) {
                        System.out.println("  matches " + String.valueOf(v2));
                    }
                }
            }
            if (loadForV != null && (matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV)) != null) {
                for (ValueNumber v2 : matchingValueNumbers) {
                    if (replaceMe.equals(v2)) continue;
                    frame.setKnownValue(v2, replacementValue);
                    if (!DEBUG) continue;
                    System.out.println("For " + String.valueOf(loadForV) + " switch from " + String.valueOf(replaceMe) + " to " + String.valueOf(v2));
                }
            }
            frame.setKnownValue(replaceMe, replacementValue);
        }
        for (int i = 0; i < prefixNumSlots; ++i) {
            if (!((ValueNumber)prevVnaFrame.getValue(i)).equals(replaceMe)) continue;
            ValueNumber corresponding = (ValueNumber)targetVnaFrame.getValue(i);
            for (int j = 0; j < targetNumSlots; ++j) {
                if (!((ValueNumber)targetVnaFrame.getValue(j)).equals(corresponding)) continue;
                frame.setValue(j, replacementValue);
            }
        }
        return frame;
    }

    public IsNullValueFrame getFactAtMidEdge(Edge edge) throws DataflowAnalysisException {
        BasicBlock block = this.isForwards() ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
        IsNullValueFrame predFact = this.createFact();
        this.copy((IsNullValueFrame)this.getResultFact(block), predFact);
        this.edgeTransfer(edge, predFact);
        IsNullValueFrame result = this.createFact();
        this.makeFactTop(result);
        this.meetInto(predFact, edge, result, false);
        return result;
    }

    static {
        if (DEBUG) {
            System.out.println("inva.debug enabled");
        }
        nullComparisonInstructionSet = new BitSet();
        nullComparisonInstructionSet.set(198);
        nullComparisonInstructionSet.set(199);
        nullComparisonInstructionSet.set(165);
        nullComparisonInstructionSet.set(166);
    }

    public static class PointerEqualityCheck {
        final ValueNumber reg1;
        final ValueNumber reg2;
        final int firstValuePC;

        public PointerEqualityCheck(ValueNumber reg1, ValueNumber reg2, int firstValuePC) {
            this.reg1 = reg1;
            this.reg2 = reg2;
            this.firstValuePC = firstValuePC;
        }
    }

    static enum PointerEqualityCheckState {
        INIT,
        START,
        SAW1,
        SAW2,
        IFEQUAL,
        IFNOTEQUAL;

    }
}

