/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.jsr305.JSR305NullnessAnnotations;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierDefault;
import javax.annotation.meta.TypeQualifierNickname;

public class TypeQualifierResolver {
    static final ClassDescriptor typeQualifier = DescriptorFactory.createClassDescriptor(TypeQualifier.class);
    static final ClassDescriptor typeQualifierNickname = DescriptorFactory.createClassDescriptor(TypeQualifierNickname.class);
    static final ClassDescriptor typeQualifierDefault = DescriptorFactory.createClassDescriptor(TypeQualifierDefault.class);
    static final ClassDescriptor elementTypeDescriptor = DescriptorFactory.createClassDescriptor(ElementType.class);
    static final ClassDescriptor eclipseNonNullByDefault = DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/NonNullByDefault");
    private static final ClassDescriptor[] NON_NULL_CLASS_DESCRIPTORS = new ClassDescriptor[]{DescriptorFactory.createClassDescriptor("edu/umd/cs/findbugs/annotations/NonNull"), DescriptorFactory.createClassDescriptor("android/support/annotation/NonNull"), DescriptorFactory.createClassDescriptor("androidx/annotation/NonNull"), DescriptorFactory.createClassDescriptor("org/jetbrains/annotations/NotNull"), DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/NonNull"), eclipseNonNullByDefault, DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/qual/NonNull"), DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/compatqual/NonNullDecl"), DescriptorFactory.createClassDescriptor("org/netbeans/api/annotations/common/NonNull"), DescriptorFactory.createClassDescriptor("lombok/NonNull")};
    private static final ClassDescriptor[] NULLABLE_CLASS_DESCRIPTORS = new ClassDescriptor[]{DescriptorFactory.createClassDescriptor("android/support/annotation/Nullable"), DescriptorFactory.createClassDescriptor("androidx/annotation/Nullable"), DescriptorFactory.createClassDescriptor("com/google/common/base/Nullable"), DescriptorFactory.createClassDescriptor("org/apache/avro/reflect/Nullable"), DescriptorFactory.createClassDescriptor("org/jetbrains/annotations/Nullable"), DescriptorFactory.createClassDescriptor("org/eclipse/jdt/annotation/Nullable"), DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/qual/Nullable"), DescriptorFactory.createClassDescriptor("org/checkerframework/checker/nullness/compatqual/NullableDecl"), DescriptorFactory.createClassDescriptor("org/netbeans/api/annotations/common/NullAllowed")};

    public static Collection<AnnotationValue> resolveTypeQualifiers(AnnotationValue value) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, new LinkedList<ClassDescriptor>());
        return result;
    }

    public static Collection<AnnotationValue> resolveTypeQualifierDefaults(Collection<AnnotationValue> values, ElementType elementType) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierDefaults(value, elementType, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void resolveTypeQualifierNicknames(AnnotationValue value, LinkedList<AnnotationValue> result, LinkedList<ClassDescriptor> onStack) {
        ClassDescriptor annotationClass = value.getAnnotationClass();
        if (onStack.contains(annotationClass)) {
            AnalysisContext.logError("Cycle found in type nicknames: " + String.valueOf(onStack));
            return;
        }
        try {
            ClassDescriptor[] classDescriptorArray;
            onStack.add(annotationClass);
            try {
                for (ClassDescriptor descriptor : NULLABLE_CLASS_DESCRIPTORS) {
                    if (!annotationClass.equals(descriptor)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(new AnnotationValue(JSR305NullnessAnnotations.CHECK_FOR_NULL), result, onStack);
                    return;
                }
                classDescriptorArray = NON_NULL_CLASS_DESCRIPTORS;
            }
            catch (MissingClassException e) {
                TypeQualifierResolver.logMissingAnnotationClass(e);
                return;
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error resolving " + String.valueOf(annotationClass), e);
                return;
            }
            for (ClassDescriptor descriptor : classDescriptorArray) {
                if (!annotationClass.equals(descriptor)) continue;
                TypeQualifierResolver.resolveTypeQualifierNicknames(new AnnotationValue(JSR305NullnessAnnotations.NONNULL), result, onStack);
                return;
            }
            {
                XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, annotationClass);
                if (!c.getAnnotationDescriptors().contains(typeQualifierNickname)) {
                    if (!c.getAnnotationDescriptors().contains(typeQualifier)) return;
                    result.add(value);
                    return;
                }
                Iterator<ClassDescriptor> iterator = c.getAnnotationDescriptors().iterator();
                while (iterator.hasNext()) {
                    ClassDescriptor d = iterator.next();
                    if (d.equals(typeQualifierNickname)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, onStack);
                }
                return;
            }
        }
        finally {
            onStack.removeLast();
        }
    }

    public static void logMissingAnnotationClass(MissingClassException e) {
        ClassDescriptor c = e.getClassDescriptor();
        if (c.getClassName().startsWith("javax.annotation") || c.getClassName().startsWith("jakarta.annotation")) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(c);
        }
    }

    public static Collection<AnnotationValue> resolveTypeQualifiers(Collection<AnnotationValue> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        LinkedList<ClassDescriptor> onStack = new LinkedList<ClassDescriptor>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, onStack);
        }
        return result;
    }

    private static void resolveTypeQualifierDefaults(AnnotationValue value, ElementType defaultFor, LinkedList<AnnotationValue> result) {
        try {
            XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, value.getAnnotationClass());
            AnnotationValue defaultAnnotation = c.getAnnotation(typeQualifierDefault);
            if (defaultAnnotation == null) {
                return;
            }
            for (Object o : (Object[])defaultAnnotation.getValue("value")) {
                if (!(o instanceof EnumValue)) continue;
                EnumValue e = (EnumValue)o;
                if (!e.desc.equals(elementTypeDescriptor) || !e.value.equals(defaultFor.name())) continue;
                for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                    if (d.equals(typeQualifierDefault)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, new LinkedList<ClassDescriptor>());
                }
                break;
            }
        }
        catch (MissingClassException e) {
            TypeQualifierResolver.logMissingAnnotationClass(e);
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error resolving " + String.valueOf(value.getAnnotationClass()), e);
        }
        catch (ClassCastException e) {
            AnalysisContext.logError("ClassCastException " + String.valueOf(value.getAnnotationClass()), e);
        }
    }
}

