/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.StackDepth;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class StackDepthAnalysis
extends ForwardDataflowAnalysis<StackDepth> {
    public static final int TOP = -1;
    public static final int BOTTOM = -2;
    private final ConstantPoolGen cpg;

    public StackDepthAnalysis(ConstantPoolGen cpg, DepthFirstSearch dfs) {
        super(dfs);
        this.cpg = cpg;
    }

    @Override
    public StackDepth createFact() {
        return new StackDepth(-1);
    }

    @Override
    public void makeFactTop(StackDepth fact) {
        fact.setDepth(-1);
    }

    @Override
    public boolean isTop(StackDepth fact) {
        return fact.getDepth() == -1;
    }

    @Override
    public boolean isFactValid(StackDepth fact) {
        int depth = fact.getDepth();
        return depth != -1 && depth != -2;
    }

    @Override
    public void copy(StackDepth source, StackDepth dest) {
        dest.setDepth(source.getDepth());
    }

    @Override
    public void initEntryFact(StackDepth entryFact) {
        entryFact.setDepth(0);
    }

    @Override
    public boolean same(StackDepth fact1, StackDepth fact2) {
        return fact1.getDepth() == fact2.getDepth();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, StackDepth fact) throws DataflowAnalysisException {
        Instruction ins = handle.getInstruction();
        int produced = ins.produceStack(this.cpg);
        int consumed = ins.consumeStack(this.cpg);
        if (produced == -2 || consumed == -2) {
            throw new IllegalStateException("Unpredictable stack delta for instruction: " + String.valueOf(handle));
        }
        int depth = fact.getDepth();
        if ((depth += produced - consumed) < 0) {
            fact.setDepth(-2);
        } else {
            fact.setDepth(depth);
        }
    }

    @Override
    public void meetInto(StackDepth fact, Edge edge, StackDepth result) {
        int a = fact.getDepth();
        int b = result.getDepth();
        int combined = a == -1 ? b : (b == -1 ? a : (a == -2 || b == -2 || a != b ? -2 : a));
        result.setDepth(combined);
    }
}

