/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.WarningSuppressor;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;

public class PackageWarningSuppressor
extends WarningSuppressor {
    private static final String BUG_TYPE = "US_USELESS_SUPPRESSION_ON_PACKAGE";
    String packageName;
    private final boolean userGeneratedPackage;

    public PackageWarningSuppressor(String bugPattern, SuppressMatchType matchType, String packageName, boolean userGeneratedPackage) {
        super(bugPattern, matchType);
        this.packageName = packageName;
        this.userGeneratedPackage = userGeneratedPackage;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        ClassAnnotation primaryClassAnnotation = bugInstance.getPrimaryClass();
        if (DEBUG) {
            System.out.println("Compare " + String.valueOf(primaryClassAnnotation) + " with " + this.packageName);
        }
        String className = primaryClassAnnotation.getClassName();
        return className.startsWith(this.packageName);
    }

    @Override
    public BugInstance buildUselessSuppressionBugInstance(UselessSuppressionDetector detector) {
        return new BugInstance(detector, BUG_TYPE, 2).addClass(this.packageName).addString(this.adjustBugPatternForMessage());
    }

    @Override
    public boolean isUselessSuppressionReportable() {
        return this.userGeneratedPackage;
    }
}

