/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.CheckBcel;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.ShowHelp;
import edu.umd.cs.findbugs.Version;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Method;
import java.util.Map;

public class LaunchAppropriateUI {
    public static final int TEXTUI = 0;
    public static final int GUI1 = 1;
    public static final int GUI2 = 2;
    public static final int SHOW_HELP = 1000;
    public static final int SHOW_VERSION = 1001;
    @StaticConstant
    public static final Map<String, Integer> uiNameToCodeMap = Map.of("textui", 0, "gui", 2, "gui1", 1, "gui2", 2, "help", 1000, "version", 1001);
    private String[] args;

    public LaunchAppropriateUI(String[] args) {
        this.args = args;
    }

    public void launch() throws Exception {
        if (!CheckBcel.check()) {
            System.exit(1);
        }
        int launchProperty = this.getLaunchProperty();
        if (GraphicsEnvironment.isHeadless() || launchProperty == 0) {
            FindBugs2.main(this.args);
        } else if (launchProperty == 1000) {
            ShowHelp.main(this.args);
        } else if (launchProperty == 1001) {
            Version.main(new String[]{"-release"});
        } else {
            Class<?> launchClass = Class.forName("edu.umd.cs.findbugs.gui2.Driver");
            Method mainMethod = launchClass.getMethod("main", this.args.getClass());
            mainMethod.invoke(null, new Object[]{this.args});
        }
    }

    private int getLaunchProperty() {
        String string;
        String firstArg;
        if (this.args.length > 0 && (firstArg = this.args[0]).startsWith("-") && uiNameToCodeMap.containsKey(string = firstArg.substring(1))) {
            String[] modifiedArgs = new String[this.args.length - 1];
            System.arraycopy(this.args, 1, modifiedArgs, 0, this.args.length - 1);
            this.args = modifiedArgs;
            return uiNameToCodeMap.get(string);
        }
        String s = System.getProperty("findbugs.launchUI");
        if (s == null) {
            for (String a : this.args) {
                if (!"-output".equals(a) && !"-xml".equals(a) && !a.endsWith(".class") && !a.endsWith(".jar")) continue;
                return 0;
            }
            s = "gui2";
        }
        if (uiNameToCodeMap.containsKey(s)) {
            return uiNameToCodeMap.get(s);
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 2;
        }
    }

    public static void main(String[] args) throws Exception {
        LaunchAppropriateUI launcher = new LaunchAppropriateUI(args);
        launcher.launch();
    }
}

