/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.JavaVersionException;
import edu.umd.cs.findbugs.SystemProperties;

public class JavaVersion {
    private final int major;
    private final int minor;
    private final String rest;
    private static JavaVersion runtimeVersion;

    public JavaVersion(String versionString) throws JavaVersionException {
        String[] strings = versionString.split("\\.", 3);
        try {
            int earlyAccess = strings[0].indexOf(45);
            if (earlyAccess > 0) {
                this.major = Integer.parseInt(strings[0].substring(0, earlyAccess));
                this.minor = 0;
                this.rest = strings[0].substring(earlyAccess);
            } else {
                this.major = Integer.parseInt(strings[0]);
                if (strings.length > 1) {
                    this.minor = Integer.parseInt(strings[1]);
                    this.rest = strings.length > 2 ? strings[2] : "";
                } else {
                    this.minor = 0;
                    this.rest = "";
                }
            }
        }
        catch (NumberFormatException e) {
            throw new JavaVersionException("Could not parse Java Version string: " + versionString, e);
        }
    }

    public JavaVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.rest = "";
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String getRest() {
        return this.rest;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.major);
        buf.append('.');
        buf.append(this.minor);
        if (this.rest != null) {
            buf.append(this.rest);
        }
        return buf.toString();
    }

    public static JavaVersion getRuntimeVersion() {
        return runtimeVersion;
    }

    public boolean isSameOrNewerThan(JavaVersion other) {
        return this.major > other.major || this.major == other.major && this.minor >= other.minor;
    }

    static {
        try {
            runtimeVersion = new JavaVersion(SystemProperties.getProperty("java.version"));
        }
        catch (JavaVersionException e) {
            runtimeVersion = new JavaVersion(1, 8);
            e.printStackTrace();
        }
    }
}

