/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.SystemProperties;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

public class I18N {
    private static final boolean DEBUG = SystemProperties.getBoolean("i18n.debug");
    public static final Locale defaultLocale = Locale.getDefault();
    private final ResourceBundle annotationDescriptionBundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.FindBugsAnnotationDescriptions", defaultLocale);
    private final ResourceBundle englishAnnotationDescriptionBundle = ResourceBundle.getBundle("edu.umd.cs.findbugs.FindBugsAnnotationDescriptions", Locale.ENGLISH);
    private static I18N theInstance = new I18N();

    I18N() {
    }

    public static I18N instance() {
        return theInstance;
    }

    @Deprecated
    @Nonnull
    public String getMessage(String key) {
        BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getAbbrev() + ": " + bugPattern.getLongDescription();
    }

    @Nonnull
    public String getShortMessage(String key) {
        BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getAbbrev() + ": " + bugPattern.getShortDescription();
    }

    @Nonnull
    public String getShortMessageWithoutCode(String key) {
        BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getShortDescription();
    }

    @Nonnull
    public String getDetailHTML(String key) {
        BugPattern bugPattern = DetectorFactoryCollection.instance().lookupBugPattern(key);
        if (bugPattern == null) {
            return L10N.getLocalString("err.missing_pattern", "Error: missing bug pattern for key") + " " + key;
        }
        return bugPattern.getDetailHTML();
    }

    public String getAnnotationDescription(String key) {
        try {
            return this.annotationDescriptionBundle.getString(key);
        }
        catch (MissingResourceException mre) {
            if (DEBUG) {
                return "TRANSLATE(" + key + ") (param={0}}";
            }
            try {
                return this.englishAnnotationDescriptionBundle.getString(key);
            }
            catch (MissingResourceException mre2) {
                return key + " {0}";
            }
        }
    }

    @Nonnull
    public String getBugTypeDescription(String shortBugType) {
        BugCode bugCode = DetectorFactoryCollection.instance().lookupBugCode(shortBugType);
        if (bugCode == null) {
            return L10N.getLocalString("err.missing_code", "Error: missing bug code for key") + " " + shortBugType;
        }
        return bugCode.getDescription();
    }

    public String getBugCategoryDescription(String category) {
        BugCategory bc = DetectorFactoryCollection.instance().getBugCategory(category);
        return bc != null ? bc.getShortDescription() : category;
    }
}

