/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.ClassWarningSuppressor;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.annotations.SuppressMatchType;
import edu.umd.cs.findbugs.detect.UselessSuppressionDetector;

public class FieldWarningSuppressor
extends ClassWarningSuppressor {
    private static final String BUG_TYPE = "US_USELESS_SUPPRESSION_ON_FIELD";
    FieldAnnotation field;
    private final boolean userGeneratedField;

    public FieldWarningSuppressor(String bugPattern, SuppressMatchType matchType, ClassAnnotation clazz, FieldAnnotation field, boolean userGeneratedClass, boolean userGeneratedField) {
        super(bugPattern, matchType, clazz, userGeneratedClass);
        this.field = field;
        this.userGeneratedField = userGeneratedField;
    }

    public String toString() {
        return String.format("Suppress %s in %s.%s", this.bugPattern, this.clazz, this.field);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        if (!super.match(bugInstance)) {
            return false;
        }
        FieldAnnotation bugField = bugInstance.getPrimaryField();
        if (bugField == null || !this.field.equals(bugField)) {
            return false;
        }
        if (DEBUG) {
            System.out.println("Suppressing " + String.valueOf(bugInstance));
        }
        return true;
    }

    @Override
    public BugInstance buildUselessSuppressionBugInstance(UselessSuppressionDetector detector) {
        return new BugInstance(detector, BUG_TYPE, 2).addClass(this.clazz.getClassDescriptor()).addField(this.field).addString(this.adjustBugPatternForMessage());
    }

    @Override
    public boolean isUselessSuppressionReportable() {
        return this.userGeneratedField && super.isUselessSuppressionReportable();
    }
}

