/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.ErrorResultIOException;
import org.forgerock.opendj.ldif.EntryWriter;

public final class ConnectionEntryWriter
implements EntryWriter {
    private final Connection connection;

    public ConnectionEntryWriter(Connection connection) {
        Validator.ensureNotNull(connection);
        this.connection = connection;
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void flush() {
    }

    @Override
    public ConnectionEntryWriter writeComment(CharSequence comment) {
        Validator.ensureNotNull(comment);
        return this;
    }

    @Override
    public ConnectionEntryWriter writeEntry(Entry entry) throws ErrorResultIOException {
        Validator.ensureNotNull(entry);
        try {
            this.connection.add(entry);
        }
        catch (ErrorResultException e) {
            throw new ErrorResultIOException(e);
        }
        return this;
    }
}

