/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class SubstringAssertionSyntaxImpl
extends AbstractSyntaxImpl {
    SubstringAssertionSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "SubstringAssertion";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength == 0) {
            return true;
        }
        if (valueLength == 1) {
            if (valueString.charAt(0) == '*') {
                invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_ONLY_WILDCARD.get());
                return false;
            }
            return true;
        }
        for (int i = 1; i < valueLength; ++i) {
            if (valueString.charAt(i) != '*' || valueString.charAt(i - 1) != '*') continue;
            invalidReason.append(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS.get((Object)valueString, (Object)i));
            return false;
        }
        return true;
    }
}

