/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class ObjectClass
extends SchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> superiorClassOIDs;
    private final ObjectClassType objectClassType;
    private final Set<String> requiredAttributeOIDs;
    private final Set<String> optionalAttributeOIDs;
    private final String definition;
    private Set<ObjectClass> superiorClasses = Collections.emptySet();
    private Set<AttributeType> declaredRequiredAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();
    private Set<AttributeType> declaredOptionalAttributes = Collections.emptySet();
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private boolean needsValidating = true;
    private boolean isValid = false;

    ObjectClass(String oid, List<String> names, String description, boolean obsolete, Set<String> superiorClassOIDs, Set<String> requiredAttributeOIDs, Set<String> optionalAttributeOIDs, ObjectClassType objectClassType, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)oid, names);
        Validator.ensureNotNull(superiorClassOIDs, requiredAttributeOIDs, optionalAttributeOIDs, (Object)objectClassType);
        this.oid = oid;
        this.names = names;
        this.isObsolete = obsolete;
        this.superiorClassOIDs = superiorClassOIDs;
        this.objectClassType = objectClassType;
        this.requiredAttributeOIDs = requiredAttributeOIDs;
        this.optionalAttributeOIDs = optionalAttributeOIDs;
        this.definition = definition != null ? definition : this.buildDefinition();
    }

    ObjectClass(String description, Map<String, List<String>> extraProperties) {
        super(description, extraProperties);
        this.oid = "1.3.6.1.4.1.1466.101.120.111";
        this.names = Collections.singletonList("extensibleObject");
        this.isObsolete = false;
        this.superiorClassOIDs = Collections.singleton("top");
        this.objectClassType = ObjectClassType.AUXILIARY;
        this.requiredAttributeOIDs = Collections.emptySet();
        this.optionalAttributeOIDs = Collections.emptySet();
        this.definition = this.buildDefinition();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ObjectClass) {
            ObjectClass other = (ObjectClass)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Set<AttributeType> getDeclaredOptionalAttributes() {
        return this.declaredOptionalAttributes;
    }

    public Set<AttributeType> getDeclaredRequiredAttributes() {
        return this.declaredRequiredAttributes;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public ObjectClassType getObjectClassType() {
        return this.objectClassType;
    }

    public String getOID() {
        return this.oid;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public Set<ObjectClass> getSuperiorClasses() {
        return this.superiorClasses;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isDescendantOf(ObjectClass objectClass) {
        for (ObjectClass sup : this.superiorClasses) {
            if (!sup.equals(objectClass) && !sup.isDescendantOf(objectClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    ObjectClass duplicate() {
        return new ObjectClass(this.oid, this.names, this.description, this.isObsolete, this.superiorClassOIDs, this.requiredAttributeOIDs, this.optionalAttributeOIDs, this.objectClassType, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.superiorClassOIDs.isEmpty()) {
            iterator = this.superiorClassOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" SUP ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" SUP ");
                buffer.append(firstName);
            }
        }
        if (this.objectClassType != null) {
            buffer.append(" ");
            buffer.append(this.objectClassType.toString());
        }
        if (!this.requiredAttributeOIDs.isEmpty()) {
            iterator = this.requiredAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            iterator = this.optionalAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
    }

    boolean validate(Schema schema, List<ObjectClass> invalidSchemaElements, List<LocalizableMessage> warnings) {
        LocalizableMessage message;
        boolean derivesTop;
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        boolean bl = derivesTop = this.objectClassType != ObjectClassType.STRUCTURAL;
        if (!this.superiorClassOIDs.isEmpty()) {
            this.superiorClasses = new HashSet<ObjectClass>(this.superiorClassOIDs.size());
            for (String superClassOid : this.superiorClassOIDs) {
                ObjectClass superiorClass;
                try {
                    superiorClass = schema.getObjectClass(superClassOid);
                }
                catch (UnknownSchemaElementException e) {
                    message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_SUPERIOR_CLASS1.get((Object)this.getNameOrOID(), (Object)superClassOid);
                    this.failValidation(invalidSchemaElements, warnings, message);
                    return false;
                }
                ObjectClassType superiorType = superiorClass.getObjectClassType();
                switch (this.objectClassType) {
                    case ABSTRACT: {
                        if (superiorType == ObjectClassType.ABSTRACT) break;
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get((Object)this.getNameOrOID(), (Object)this.objectClassType.toString(), (Object)superiorType.toString(), (Object)superiorClass.getNameOrOID());
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    case AUXILIARY: {
                        if (superiorType == ObjectClassType.ABSTRACT || superiorType == ObjectClassType.AUXILIARY) break;
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get((Object)this.getNameOrOID(), (Object)this.objectClassType.toString(), (Object)superiorType.toString(), (Object)superiorClass.getNameOrOID());
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    case STRUCTURAL: {
                        if (superiorType == ObjectClassType.ABSTRACT || superiorType == ObjectClassType.STRUCTURAL) break;
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_TYPE1.get((Object)this.getNameOrOID(), (Object)this.objectClassType.toString(), (Object)superiorType.toString(), (Object)superiorClass.getNameOrOID());
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                }
                if (!derivesTop && superiorType == ObjectClassType.STRUCTURAL) {
                    derivesTop = true;
                }
                if (!superiorClass.validate(schema, invalidSchemaElements, warnings)) {
                    message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_INVALID_SUPERIOR_CLASS.get((Object)this.getNameOrOID(), (Object)superClassOid);
                    this.failValidation(invalidSchemaElements, warnings, message);
                    return false;
                }
                Iterator<AttributeType> i = superiorClass.getRequiredAttributes().iterator();
                if (i.hasNext() && this.requiredAttributes == Collections.EMPTY_SET) {
                    this.requiredAttributes = new HashSet<AttributeType>();
                }
                while (i.hasNext()) {
                    this.requiredAttributes.add(i.next());
                }
                i = superiorClass.getRequiredAttributes().iterator();
                if (i.hasNext() && this.requiredAttributes == Collections.EMPTY_SET) {
                    this.requiredAttributes = new HashSet<AttributeType>();
                }
                while (i.hasNext()) {
                    this.requiredAttributes.add(i.next());
                }
                this.superiorClasses.add(superiorClass);
            }
        }
        if (!derivesTop) {
            derivesTop = this.isDescendantOf(schema.getObjectClass("2.5.6.0"));
        }
        if (!derivesTop) {
            LocalizableMessage message2 = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_STRUCTURAL_SUPERIOR_NOT_TOP1.get((Object)this.getNameOrOID());
            this.failValidation(invalidSchemaElements, warnings, message2);
            return false;
        }
        if (this.oid.equals("1.3.6.1.4.1.1466.101.120.111")) {
            this.declaredOptionalAttributes = new HashSet<AttributeType>(this.requiredAttributeOIDs.size());
            for (AttributeType attributeType : schema.getAttributeTypes()) {
                if (attributeType.getUsage() != AttributeUsage.USER_APPLICATIONS) continue;
                this.declaredOptionalAttributes.add(attributeType);
            }
            this.optionalAttributes = this.declaredRequiredAttributes;
        } else {
            AttributeType attributeType;
            if (!this.requiredAttributeOIDs.isEmpty()) {
                this.declaredRequiredAttributes = new HashSet<AttributeType>(this.requiredAttributeOIDs.size());
                for (String requiredAttribute : this.requiredAttributeOIDs) {
                    try {
                        attributeType = schema.getAttributeType(requiredAttribute);
                    }
                    catch (UnknownSchemaElementException e) {
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_REQUIRED_ATTR1.get((Object)this.getNameOrOID(), (Object)requiredAttribute);
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    this.declaredRequiredAttributes.add(attributeType);
                }
                if (this.requiredAttributes == Collections.EMPTY_SET) {
                    this.requiredAttributes = this.declaredRequiredAttributes;
                } else {
                    this.requiredAttributes.addAll(this.declaredRequiredAttributes);
                }
            }
            if (!this.optionalAttributeOIDs.isEmpty()) {
                this.declaredOptionalAttributes = new HashSet<AttributeType>(this.optionalAttributeOIDs.size());
                for (String optionalAttribute : this.optionalAttributeOIDs) {
                    try {
                        attributeType = schema.getAttributeType(optionalAttribute);
                    }
                    catch (UnknownSchemaElementException e) {
                        message = CoreMessages.WARN_ATTR_SYNTAX_OBJECTCLASS_UNKNOWN_OPTIONAL_ATTR1.get((Object)this.getNameOrOID(), (Object)optionalAttribute);
                        this.failValidation(invalidSchemaElements, warnings, message);
                        return false;
                    }
                    this.declaredOptionalAttributes.add(attributeType);
                }
                if (this.optionalAttributes == Collections.EMPTY_SET) {
                    this.optionalAttributes = this.declaredOptionalAttributes;
                } else {
                    this.optionalAttributes.addAll(this.declaredOptionalAttributes);
                }
            }
        }
        this.declaredOptionalAttributes = Collections.unmodifiableSet(this.declaredOptionalAttributes);
        this.declaredRequiredAttributes = Collections.unmodifiableSet(this.declaredRequiredAttributes);
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
        this.superiorClasses = Collections.unmodifiableSet(this.superiorClasses);
        this.isValid = true;
        return true;
    }

    private void failValidation(List<ObjectClass> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_OC_VALIDATION_FAIL.get((Object)this.toString(), (Object)message));
    }
}

