/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class NameFormSyntaxImpl
extends AbstractSyntaxImpl {
    NameFormSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.30";
    }

    @Override
    public String getName() {
        return "NameFormDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            LocalizableMessage message;
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message2 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE1.get((Object)definition);
                DecodeException e = DecodeException.error(message2);
                StaticUtils.DEBUG_LOG.throwing("NameFormSyntax", "valueIsAcceptable", e);
                throw e;
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message3 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)Character.valueOf(c));
                DecodeException e = DecodeException.error(message3);
                StaticUtils.DEBUG_LOG.throwing("NameFormSyntax", "valueIsAcceptable", e);
                throw e;
            }
            reader.skipWhitespaces();
            SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions());
            String structuralClass = null;
            Set<String> requiredAttributes = null;
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    SchemaUtils.readNameDescriptors(reader, schema.allowMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) continue;
                if (tokenName.equalsIgnoreCase("oc")) {
                    structuralClass = SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.equalsIgnoreCase("must")) {
                    requiredAttributes = SchemaUtils.readOIDs(reader, schema.allowMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.equalsIgnoreCase("may")) {
                    SchemaUtils.readOIDs(reader, schema.allowMalformedNamesAndOptions());
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    SchemaUtils.readExtensions(reader);
                    continue;
                }
                LocalizableMessage message4 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                DecodeException e = DecodeException.error(message4);
                StaticUtils.DEBUG_LOG.throwing("NameFormSyntax", "valueIsAcceptable", e);
                throw e;
            }
            if (structuralClass == null) {
                message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS1.get((Object)definition);
                DecodeException e = DecodeException.error(message);
                StaticUtils.DEBUG_LOG.throwing("NameFormSyntax", "valueIsAcceptable", e);
                throw e;
            }
            if (requiredAttributes == null || requiredAttributes.size() == 0) {
                message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_REQUIRED_ATTR.get((Object)definition);
                DecodeException e = DecodeException.error(message);
                StaticUtils.DEBUG_LOG.throwing("NameFormSyntax", "valueIsAcceptable", e);
                throw e;
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_INVALID1.get((Object)definition, (Object)de.getMessageObject()));
            return false;
        }
    }
}

