/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class NameForm
extends SchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final String structuralClassOID;
    private final Set<String> optionalAttributeOIDs;
    private final Set<String> requiredAttributeOIDs;
    private final String definition;
    private ObjectClass structuralClass;
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private Set<AttributeType> requiredAttributes = Collections.emptySet();

    NameForm(String oid, List<String> names, String description, boolean obsolete, String structuralClassOID, Set<String> requiredAttributeOIDs, Set<String> optionalAttributeOIDs, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)oid, names);
        Validator.ensureNotNull((Object)structuralClassOID, requiredAttributeOIDs, optionalAttributeOIDs);
        Validator.ensureTrue(requiredAttributeOIDs.size() > 0, "required attribute is empty");
        this.oid = oid;
        this.names = names;
        this.isObsolete = obsolete;
        this.structuralClassOID = structuralClassOID;
        this.requiredAttributeOIDs = requiredAttributeOIDs;
        this.optionalAttributeOIDs = optionalAttributeOIDs;
        this.definition = definition != null ? definition : this.buildDefinition();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NameForm) {
            NameForm other = (NameForm)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOID() {
        return this.oid;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    NameForm duplicate() {
        return new NameForm(this.oid, this.names, this.description, this.isObsolete, this.structuralClassOID, this.requiredAttributeOIDs, this.optionalAttributeOIDs, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" OC ");
        buffer.append(this.structuralClassOID);
        if (!this.requiredAttributeOIDs.isEmpty()) {
            iterator = this.requiredAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            iterator = this.optionalAttributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        AttributeType attributeType;
        try {
            this.structuralClass = schema.getObjectClass(this.structuralClassOID);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_STRUCTURAL_CLASS1.get((Object)this.getNameOrOID(), (Object)this.structuralClassOID);
            throw new SchemaException(message, (Throwable)((Object)e));
        }
        if (this.structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_STRUCTURAL_CLASS_NOT_STRUCTURAL1.get((Object)this.getNameOrOID(), (Object)this.structuralClass.getNameOrOID(), (Object)String.valueOf((Object)this.structuralClass.getObjectClassType()));
            throw new SchemaException(message);
        }
        this.requiredAttributes = new HashSet<AttributeType>(this.requiredAttributeOIDs.size());
        for (String oid : this.requiredAttributeOIDs) {
            try {
                attributeType = schema.getAttributeType(oid);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_REQUIRED_ATTR1.get((Object)this.getNameOrOID(), (Object)oid);
                throw new SchemaException(message, (Throwable)((Object)e));
            }
            this.requiredAttributes.add(attributeType);
        }
        if (!this.optionalAttributeOIDs.isEmpty()) {
            this.optionalAttributes = new HashSet<AttributeType>(this.optionalAttributeOIDs.size());
            for (String oid : this.optionalAttributeOIDs) {
                try {
                    attributeType = schema.getAttributeType(oid);
                }
                catch (UnknownSchemaElementException e) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_OPTIONAL_ATTR1.get((Object)this.getNameOrOID(), (Object)oid);
                    throw new SchemaException(message, (Throwable)((Object)e));
                }
                this.optionalAttributes.add(attributeType);
            }
        }
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
    }
}

