/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class JPEGSyntaxImpl
extends AbstractSyntaxImpl {
    JPEGSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.17";
    }

    @Override
    public String getName() {
        return "JPEG";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.18";
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        if (!schema.allowMalformedJPEGPhotos()) {
            if (value.length() < 10) {
                return false;
            }
            if (value.byteAt(0) != -1 && value.byteAt(1) != -40) {
                return false;
            }
            if (value.byteAt(2) == -1 && value.byteAt(3) == -32 && value.byteAt(6) == 74 && value.byteAt(7) == 70 && value.byteAt(8) == 73 && value.byteAt(9) == 70) {
                return true;
            }
            return value.byteAt(2) == -1 && value.byteAt(3) == -31 && value.byteAt(6) == 69 && value.byteAt(7) == 120 && value.byteAt(8) == 105 && value.byteAt(9) == 102;
        }
        return true;
    }
}

