/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class IntegerEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    IntegerEqualityMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        try {
            return ByteString.valueOf(Integer.parseInt(value.toString()));
        }
        catch (Exception e) {
            StaticUtils.DEBUG_LOG.throwing("IntegerEqualityMatchingRule", "normalizeAttributeValue", e);
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_INTEGER.get((Object)value.toString());
            throw DecodeException.error(message);
        }
    }
}

