/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StringPrepProfile;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class DirectoryStringFirstComponentEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    DirectoryStringFirstComponentEqualityMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return new AbstractMatchingRuleImpl.DefaultEqualityAssertion(SchemaConstants.SINGLE_SPACE_VALUE);
            }
            return new AbstractMatchingRuleImpl.DefaultEqualityAssertion(ByteString.empty());
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return new AbstractMatchingRuleImpl.DefaultEqualityAssertion(ByteString.valueOf(buffer.toString()));
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String definition = value.toString();
        SubstringReader reader = new SubstringReader(definition);
        reader.skipWhitespaces();
        if (reader.remaining() <= 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EMPTY_VALUE.get();
            throw DecodeException.error(message);
        }
        char c = reader.read();
        if (c != '(') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
            throw DecodeException.error(message);
        }
        reader.skipWhitespaces();
        String string = SchemaUtils.readQuotedString(reader);
        return ByteString.valueOf(string);
    }
}

