/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.opendj.ldap.schema.AttributeTypeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.AuthPasswordExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.AuthPasswordSyntaxImpl;
import org.forgerock.opendj.ldap.schema.BinarySyntaxImpl;
import org.forgerock.opendj.ldap.schema.BitStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.BitStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.BooleanEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.BooleanSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CaseExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactIA5EqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactIA5SubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseExactSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreIA5EqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreIA5SubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreListEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreListSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CaseIgnoreSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.CertificateListSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CertificatePairSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CertificateSyntaxImpl;
import org.forgerock.opendj.ldap.schema.CountryStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DITContentRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DITStructureRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DeliveryMethodSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DirectoryStringFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.DirectoryStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DistinguishedNameEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.DistinguishedNameSyntaxImpl;
import org.forgerock.opendj.ldap.schema.DoubleMetaphoneApproximateMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.EnhancedGuideSyntaxImpl;
import org.forgerock.opendj.ldap.schema.FacsimileNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.FaxSyntaxImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.GeneralizedTimeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.GuideSyntaxImpl;
import org.forgerock.opendj.ldap.schema.IA5StringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.IntegerEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.IntegerSyntaxImpl;
import org.forgerock.opendj.ldap.schema.JPEGSyntaxImpl;
import org.forgerock.opendj.ldap.schema.KeywordEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.LDAPSyntaxDescriptionSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleUseSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NameAndOptionalUIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NameFormSyntaxImpl;
import org.forgerock.opendj.ldap.schema.NumericStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.NumericStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.OIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ObjectClassSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ObjectIdentifierFirstComponentEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.OctetStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.OtherMailboxSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PostalAddressSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PresentationAddressEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.PresentationAddressSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.ProtocolInformationEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.ProtocolInformationSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SubstringAssertionSyntaxImpl;
import org.forgerock.opendj.ldap.schema.SupportedAlgorithmSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TelephoneNumberEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.TelephoneNumberSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.TelephoneNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TeletexTerminalIdentifierSyntaxImpl;
import org.forgerock.opendj.ldap.schema.TelexNumberSyntaxImpl;
import org.forgerock.opendj.ldap.schema.UTCTimeSyntaxImpl;
import org.forgerock.opendj.ldap.schema.UUIDEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UUIDOrderingMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UUIDSyntaxImpl;
import org.forgerock.opendj.ldap.schema.UniqueMemberEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UserPasswordExactEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.UserPasswordSyntaxImpl;
import org.forgerock.opendj.ldap.schema.WordEqualityMatchingRuleImpl;

final class CoreSchemaImpl {
    private static final Map<String, List<String>> X500_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("X.500"));
    private static final Map<String, List<String>> RFC2252_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 2252"));
    private static final Map<String, List<String>> RFC3045_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 3045"));
    private static final Map<String, List<String>> RFC3112_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 3112"));
    private static final Map<String, List<String>> RFC4512_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4512"));
    private static final Map<String, List<String>> RFC4517_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4517"));
    private static final Map<String, List<String>> RFC4519_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4519"));
    private static final Map<String, List<String>> RFC4530_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 4530"));
    private static final Map<String, List<String>> RFC5020_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("RFC 5020"));
    static final Map<String, List<String>> OPENDS_ORIGIN = Collections.singletonMap("X-ORIGIN", Collections.singletonList("OpenDS Directory Server"));
    private static final String EMPTY_STRING = "".intern();
    private static final Set<String> EMPTY_STRING_SET = Collections.emptySet();
    private static final Schema SINGLETON;

    static Schema getInstance() {
        return SINGLETON;
    }

    private static void addRFC3045(SchemaBuilder builder) {
        builder.addAttributeType("1.3.6.1.1.4", Collections.singletonList("vendorName"), EMPTY_STRING, false, null, "1.3.6.1.4.1.1466.109.114.1", null, null, null, "1.3.6.1.4.1.1466.115.121.1.15", true, false, true, AttributeUsage.DSA_OPERATION, RFC3045_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.1.5", Collections.singletonList("vendorVersion"), EMPTY_STRING, false, null, "1.3.6.1.4.1.1466.109.114.1", null, null, null, "1.3.6.1.4.1.1466.115.121.1.15", true, false, true, AttributeUsage.DSA_OPERATION, RFC3045_ORIGIN, false);
    }

    private static void addRFC3112(SchemaBuilder builder) {
        builder.addSyntax("1.3.6.1.4.1.4203.1.1.2", "Authentication Password Syntax", RFC3112_ORIGIN, new AuthPasswordSyntaxImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.4203.1.2.2", Collections.singletonList("authPasswordExactMatch"), "authentication password exact matching rule", false, "1.3.6.1.4.1.4203.1.1.2", RFC3112_ORIGIN, new AuthPasswordExactEqualityMatchingRuleImpl(), false);
        builder.addAttributeType("1.3.6.1.4.1.4203.1.3.3", Collections.singletonList("supportedAuthPasswordSchemes"), "supported password storage schemes", false, null, "1.3.6.1.4.1.1466.109.114.1", null, null, null, "1.3.6.1.4.1.1466.115.121.1.26", false, false, false, AttributeUsage.DSA_OPERATION, RFC3112_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.4203.1.3.4", Collections.singletonList("authPassword"), "password authentication information", false, null, "1.3.6.1.4.1.4203.1.2.2", null, null, null, "1.3.6.1.4.1.4203.1.1.2", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC3112_ORIGIN, false);
        builder.addObjectClass("1.3.6.1.4.1.4203.1.4.7", Collections.singletonList("authPasswordObject"), "authentication password mix in class", false, EMPTY_STRING_SET, EMPTY_STRING_SET, Collections.singleton("authPassword"), ObjectClassType.AUXILIARY, RFC3112_ORIGIN, false);
    }

    private static void addRFC4519(SchemaBuilder builder) {
        builder.addAttributeType("2.5.4.15", Collections.singletonList("businessCategory"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.41", Collections.singletonList("name"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.6", Arrays.asList("c", "countryName"), EMPTY_STRING, false, "name", null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.11", true, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.3", Arrays.asList("cn", "commonName"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("0.9.2342.19200300.100.1.25", Arrays.asList("dc", "domainComponent"), EMPTY_STRING, false, null, "1.3.6.1.4.1.1466.109.114.2", null, "1.3.6.1.4.1.1466.109.114.3", null, "1.3.6.1.4.1.1466.115.121.1.26", true, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.13", Collections.singletonList("description"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.27", Collections.singletonList("destinationIndicator"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.44", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.49", Collections.singletonList("distinguishedName"), EMPTY_STRING, false, null, "2.5.13.1", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.46", Collections.singletonList("dnQualifier"), EMPTY_STRING, false, null, "2.5.13.2", "2.5.13.3", "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.44", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.47", Collections.singletonList("enhancedSearchGuide"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.21", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.23", Collections.singletonList("facsimileTelephoneNumber"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.22", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.44", Collections.singletonList("generationQualifier"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.42", Collections.singletonList("givenName"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.51", Collections.singletonList("houseIdentifier"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.43", Collections.singletonList("initials"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.25", Collections.singletonList("internationalISDNNumber"), EMPTY_STRING, false, null, "2.5.13.8", null, "2.5.13.10", null, "1.3.6.1.4.1.1466.115.121.1.36", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.7", Arrays.asList("l", "localityName"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.31", Collections.singletonList("member"), EMPTY_STRING, false, "distinguishedName", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.10", Arrays.asList("o", "organizationName"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.11", Arrays.asList("ou", "organizationalUnitName"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.32", Collections.singletonList("owner"), EMPTY_STRING, false, "distinguishedName", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.19", Collections.singletonList("physicalDeliveryOfficeName"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.16", Collections.singletonList("postalAddress"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.17", Collections.singletonList("postalCode"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.18", Collections.singletonList("postOfficeBox"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.28", Collections.singletonList("preferredDeliveryMethod"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.14", true, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.26", Collections.singletonList("registeredAddress"), EMPTY_STRING, false, "postalAddress", null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.41", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.33", Collections.singletonList("roleOccupant"), EMPTY_STRING, false, "distinguishedName", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.14", Collections.singletonList("searchGuide"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.25", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.34", Collections.singletonList("seeAlso"), EMPTY_STRING, false, "distinguishedName", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.5", Collections.singletonList("serialNumber"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.44", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.4", Arrays.asList("sn", "surname"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.8", Arrays.asList("st", "stateOrProvinceName"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.9", Arrays.asList("street", "streetAddress"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.20", Collections.singletonList("telephoneNumber"), EMPTY_STRING, false, null, "2.5.13.20", null, "2.5.13.21", null, "1.3.6.1.4.1.1466.115.121.1.50", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.22", Collections.singletonList("teletexTerminalIdentifier"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.51", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.21", Collections.singletonList("telexNumber"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.52", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.12", Collections.singletonList("title"), EMPTY_STRING, false, "name", null, null, null, null, null, false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("0.9.2342.19200300.100.1.1", Arrays.asList("uid", "userid"), EMPTY_STRING, false, null, "2.5.13.2", null, "2.5.13.4", null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.50", Collections.singletonList("uniqueMember"), EMPTY_STRING, false, null, "2.5.13.23", null, null, null, "1.3.6.1.4.1.1466.115.121.1.34", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.35", Collections.singletonList("userPassword"), EMPTY_STRING, false, null, "2.5.13.17", null, null, null, "1.3.6.1.4.1.1466.115.121.1.40", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.24", Collections.singletonList("x121Address"), EMPTY_STRING, false, null, "2.5.13.8", null, "2.5.13.10", null, "1.3.6.1.4.1.1466.115.121.1.36", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        builder.addAttributeType("2.5.4.45", Collections.singletonList("x500UniqueIdentifier"), EMPTY_STRING, false, null, "2.5.13.16", null, null, null, "1.3.6.1.4.1.1466.115.121.1.6", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4519_ORIGIN, false);
        HashSet<String> attrs = new HashSet<String>();
        attrs.add("seeAlso");
        attrs.add("ou");
        attrs.add("l");
        attrs.add("description");
        builder.addObjectClass("2.5.6.11", Collections.singletonList("applicationProcess"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("cn"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("searchGuide");
        attrs.add("description");
        builder.addObjectClass("2.5.6.2", Collections.singletonList("country"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("c"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        builder.addObjectClass("1.3.6.1.4.1.1466.344", Collections.singletonList("dcObject"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("dc"), EMPTY_STRING_SET, ObjectClassType.AUXILIARY, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("serialNumber");
        attrs.add("seeAlso");
        attrs.add("owner");
        attrs.add("ou");
        attrs.add("o");
        attrs.add("l");
        attrs.add("description");
        builder.addObjectClass("2.5.6.14", Collections.singletonList("device"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("cn"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        HashSet<String> must = new HashSet<String>();
        must.add("member");
        must.add("cn");
        attrs = new HashSet();
        attrs.add("businessCategory");
        attrs.add("seeAlso");
        attrs.add("owner");
        attrs.add("ou");
        attrs.add("o");
        attrs.add("description");
        builder.addObjectClass("2.5.6.9", Collections.singletonList("groupOfNames"), EMPTY_STRING, false, Collections.singleton("top"), must, attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("businessCategory");
        attrs.add("seeAlso");
        attrs.add("owner");
        attrs.add("ou");
        attrs.add("o");
        attrs.add("description");
        builder.addObjectClass("2.5.6.17", Collections.singletonList("groupOfUniqueNames"), EMPTY_STRING, false, Collections.singleton("top"), must, attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("street");
        attrs.add("seeAlso");
        attrs.add("searchGuide");
        attrs.add("st");
        attrs.add("l");
        attrs.add("description");
        builder.addObjectClass("2.5.6.3", Collections.singletonList("locality"), EMPTY_STRING, false, Collections.singleton("top"), EMPTY_STRING_SET, attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("userPassword");
        attrs.add("searchGuide");
        attrs.add("seeAlso");
        attrs.add("businessCategory");
        attrs.add("x121Address");
        attrs.add("registeredAddress");
        attrs.add("destinationIndicator");
        attrs.add("preferredDeliveryMethod");
        attrs.add("telexNumber");
        attrs.add("teletexTerminalIdentifier");
        attrs.add("telephoneNumber");
        attrs.add("internationalISDNNumber");
        attrs.add("facsimileTelephoneNumber");
        attrs.add("street");
        attrs.add("postOfficeBox");
        attrs.add("postalCode");
        attrs.add("postalAddress");
        attrs.add("physicalDeliveryOfficeName");
        attrs.add("st");
        attrs.add("l");
        attrs.add("description");
        builder.addObjectClass("2.5.6.4", Collections.singletonList("organization"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("o"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("title");
        attrs.add("x121Address");
        attrs.add("registeredAddress");
        attrs.add("destinationIndicator");
        attrs.add("preferredDeliveryMethod");
        attrs.add("telexNumber");
        attrs.add("teletexTerminalIdentifier");
        attrs.add("telephoneNumber");
        attrs.add("internationalISDNNumber");
        attrs.add("facsimileTelephoneNumber");
        attrs.add("street");
        attrs.add("postOfficeBox");
        attrs.add("postalCode");
        attrs.add("postalAddress");
        attrs.add("physicalDeliveryOfficeName");
        attrs.add("ou");
        attrs.add("st");
        attrs.add("l");
        builder.addObjectClass("2.5.6.7", Collections.singletonList("organizationalPerson"), EMPTY_STRING, false, Collections.singleton("person"), EMPTY_STRING_SET, attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("x121Address");
        attrs.add("registeredAddress");
        attrs.add("destinationIndicator");
        attrs.add("preferredDeliveryMethod");
        attrs.add("telexNumber");
        attrs.add("teletexTerminalIdentifier");
        attrs.add("telephoneNumber");
        attrs.add("internationalISDNNumber");
        attrs.add("facsimileTelephoneNumber");
        attrs.add("seeAlso");
        attrs.add("roleOccupant");
        attrs.add("preferredDeliveryMethod");
        attrs.add("street");
        attrs.add("postOfficeBox");
        attrs.add("postalCode");
        attrs.add("postalAddress");
        attrs.add("physicalDeliveryOfficeName");
        attrs.add("ou");
        attrs.add("st");
        attrs.add("l");
        attrs.add("description");
        builder.addObjectClass("2.5.6.8", Collections.singletonList("organizationalRole"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("cn"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("businessCategory");
        attrs.add("description");
        attrs.add("destinationIndicator");
        attrs.add("facsimileTelephoneNumber");
        attrs.add("internationalISDNNumber");
        attrs.add("l");
        attrs.add("physicalDeliveryOfficeName");
        attrs.add("postalAddress");
        attrs.add("postalCode");
        attrs.add("postOfficeBox");
        attrs.add("preferredDeliveryMethod");
        attrs.add("registeredAddress");
        attrs.add("searchGuide");
        attrs.add("seeAlso");
        attrs.add("st");
        attrs.add("street");
        attrs.add("telephoneNumber");
        attrs.add("teletexTerminalIdentifier");
        attrs.add("telexNumber");
        attrs.add("userPassword");
        attrs.add("x121Address");
        builder.addObjectClass("2.5.6.5", Collections.singletonList("organizationalUnit"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("ou"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        must = new HashSet();
        must.add("sn");
        must.add("cn");
        attrs = new HashSet();
        attrs.add("userPassword");
        attrs.add("telephoneNumber");
        attrs.add("destinationIndicator");
        attrs.add("seeAlso");
        attrs.add("description");
        builder.addObjectClass("2.5.6.6", Collections.singletonList("person"), EMPTY_STRING, false, Collections.singleton("top"), must, attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        attrs = new HashSet();
        attrs.add("businessCategory");
        attrs.add("x121Address");
        attrs.add("registeredAddress");
        attrs.add("destinationIndicator");
        attrs.add("preferredDeliveryMethod");
        attrs.add("telexNumber");
        attrs.add("teletexTerminalIdentifier");
        attrs.add("telephoneNumber");
        attrs.add("internationalISDNNumber");
        attrs.add("facsimileTelephoneNumber");
        attrs.add("preferredDeliveryMethod");
        attrs.add("street");
        attrs.add("postOfficeBox");
        attrs.add("postalCode");
        attrs.add("postalAddress");
        attrs.add("physicalDeliveryOfficeName");
        attrs.add("st");
        attrs.add("l");
        builder.addObjectClass("2.5.6.10", Collections.singletonList("residentialPerson"), EMPTY_STRING, false, Collections.singleton("person"), Collections.singleton("l"), attrs, ObjectClassType.STRUCTURAL, RFC4519_ORIGIN, false);
        builder.addObjectClass("1.3.6.1.1.3.1", Collections.singletonList("uidObject"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("uid"), attrs, ObjectClassType.AUXILIARY, RFC4519_ORIGIN, false);
    }

    private static void addRFC4530(SchemaBuilder builder) {
        builder.addSyntax("1.3.6.1.1.16.1", "UUID", RFC4530_ORIGIN, new UUIDSyntaxImpl(), false);
        builder.addMatchingRule("1.3.6.1.1.16.2", Collections.singletonList("uuidMatch"), EMPTY_STRING, false, "1.3.6.1.1.16.1", RFC4530_ORIGIN, new UUIDEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.1.16.3", Collections.singletonList("uuidOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.1.16.1", RFC4530_ORIGIN, new UUIDOrderingMatchingRuleImpl(), false);
        builder.addAttributeType("1.3.6.1.1.16.4", Collections.singletonList("entryUUID"), "UUID of the entry", false, null, "1.3.6.1.1.16.2", "1.3.6.1.1.16.3", null, null, "1.3.6.1.1.16.1", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4530_ORIGIN, false);
    }

    private static void addRFC5020(SchemaBuilder builder) {
        builder.addAttributeType("1.3.6.1.1.20", Collections.singletonList("entryDN"), "DN of the entry", false, null, "2.5.13.1", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC5020_ORIGIN, false);
    }

    private static void addSunProprietary(SchemaBuilder builder) {
        builder.addSyntax("1.3.6.1.4.1.26027.1.3.1", "User Password", OPENDS_ORIGIN, new UserPasswordSyntaxImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.26027.1.4.2", Collections.singletonList("ds-mr-user-password-exact"), "user password exact matching rule", false, "1.3.6.1.4.1.26027.1.3.1", OPENDS_ORIGIN, new UserPasswordExactEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.26027.1.4.1", Collections.singletonList("ds-mr-double-metaphone-approx"), "Double Metaphone Approximate Match", false, "1.3.6.1.4.1.1466.115.121.1.15", OPENDS_ORIGIN, new DoubleMetaphoneApproximateMatchingRuleImpl(), false);
    }

    private static void defaultAttributeTypes(SchemaBuilder builder) {
        builder.addAttributeType("2.5.4.0", Collections.singletonList("objectClass"), EMPTY_STRING, false, null, "objectIdentifierMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.38", false, false, false, AttributeUsage.USER_APPLICATIONS, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.4.1", Collections.singletonList("aliasedObjectName"), EMPTY_STRING, false, null, "distinguishedNameMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", true, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.18.1", Collections.singletonList("createTimestamp"), EMPTY_STRING, false, null, "generalizedTimeMatch", "generalizedTimeOrderingMatch", null, null, "1.3.6.1.4.1.1466.115.121.1.24", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.18.2", Collections.singletonList("modifyTimestamp"), EMPTY_STRING, false, null, "generalizedTimeMatch", "generalizedTimeOrderingMatch", null, null, "1.3.6.1.4.1.1466.115.121.1.24", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.18.3", Collections.singletonList("creatorsName"), EMPTY_STRING, false, null, "distinguishedNameMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.18.4", Collections.singletonList("modifiersName"), EMPTY_STRING, false, null, "distinguishedNameMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.18.10", Collections.singletonList("subschemaSubentry"), EMPTY_STRING, false, null, "distinguishedNameMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.5", Collections.singletonList("attributeTypes"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.3", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.6", Collections.singletonList("objectClasses"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.37", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.4", Collections.singletonList("matchingRules"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.30", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.8", Collections.singletonList("matchingRuleUse"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.31", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.9", Collections.singletonList("structuralObjectClass"), EMPTY_STRING, false, null, "objectIdentifierMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.38", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.10", Collections.singletonList("governingStructureRule"), EMPTY_STRING, false, null, "integerMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.27", true, false, true, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.5", Collections.singletonList("namingContexts"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.12", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.6", Collections.singletonList("altServer"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.26", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.7", Collections.singletonList("supportedExtension"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.38", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.13", Collections.singletonList("supportedControl"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.38", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.14", Collections.singletonList("supportedSASLMechanisms"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.15", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.4203.1.3.5", Collections.singletonList("supportedFeatures"), EMPTY_STRING, false, null, "objectIdentifierMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.38", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.15", Collections.singletonList("supportedLDAPVersion"), EMPTY_STRING, false, null, null, null, null, null, "1.3.6.1.4.1.1466.115.121.1.27", false, false, false, AttributeUsage.DSA_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("1.3.6.1.4.1.1466.101.120.16", Collections.singletonList("ldapSyntaxes"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.54", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.1", Collections.singletonList("ditStructureRules"), EMPTY_STRING, false, null, "integerFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.17", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.7", Collections.singletonList("nameForms"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.35", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
        builder.addAttributeType("2.5.21.2", Collections.singletonList("ditContentRules"), EMPTY_STRING, false, null, "objectIdentifierFirstComponentMatch", null, null, null, "1.3.6.1.4.1.1466.115.121.1.16", false, false, false, AttributeUsage.DIRECTORY_OPERATION, RFC4512_ORIGIN, false);
    }

    private static void defaultMatchingRules(SchemaBuilder builder) {
        builder.addMatchingRule("2.5.13.16", Collections.singletonList("bitStringMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.6", RFC4512_ORIGIN, new BitStringEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.13", Collections.singletonList("booleanMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.7", RFC4512_ORIGIN, new BooleanEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.1466.109.114.1", Collections.singletonList("caseExactIA5Match"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.26", RFC4512_ORIGIN, new CaseExactIA5EqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.26027.1.4.902", Collections.singletonList("caseExactIA5SubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new CaseExactIA5SubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.5", Collections.singletonList("caseExactMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new CaseExactEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.6", Collections.singletonList("caseExactOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new CaseExactOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.7", Collections.singletonList("caseExactSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new CaseExactSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.1466.109.114.2", Collections.singletonList("caseIgnoreIA5Match"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.26", RFC4512_ORIGIN, new CaseIgnoreIA5EqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("1.3.6.1.4.1.1466.109.114.3", Collections.singletonList("caseIgnoreIA5SubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new CaseIgnoreIA5SubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.11", Collections.singletonList("caseIgnoreListMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.41", RFC4512_ORIGIN, new CaseIgnoreListEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.12", Collections.singletonList("caseIgnoreListSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new CaseIgnoreListSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.2", Collections.singletonList("caseIgnoreMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new CaseIgnoreEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.3", Collections.singletonList("caseIgnoreOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new CaseIgnoreOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.4", Collections.singletonList("caseIgnoreSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new CaseIgnoreSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.31", Collections.singletonList("directoryStringFirstComponentMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new DirectoryStringFirstComponentEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.1", Collections.singletonList("distinguishedNameMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.12", RFC4512_ORIGIN, new DistinguishedNameEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.27", Collections.singletonList("generalizedTimeMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.24", RFC4512_ORIGIN, new GeneralizedTimeEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.28", Collections.singletonList("generalizedTimeOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.24", RFC4512_ORIGIN, new GeneralizedTimeOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.29", Collections.singletonList("integerFirstComponentMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.27", RFC4512_ORIGIN, new IntegerFirstComponentEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.14", Collections.singletonList("integerMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.27", RFC4512_ORIGIN, new IntegerEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.15", Collections.singletonList("integerOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.27", RFC4512_ORIGIN, new IntegerOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.33", Collections.singletonList("keywordMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new KeywordEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.8", Collections.singletonList("numericStringMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.36", RFC4512_ORIGIN, new NumericStringEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.9", Collections.singletonList("numericStringOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.36", RFC4512_ORIGIN, new NumericStringOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.10", Collections.singletonList("numericStringSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new NumericStringSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.30", Collections.singletonList("objectIdentifierFirstComponentMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.38", RFC4512_ORIGIN, new ObjectIdentifierFirstComponentEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.0", Collections.singletonList("objectIdentifierMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.38", RFC4512_ORIGIN, new ObjectIdentifierEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.17", Collections.singletonList("octetStringMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.40", RFC4512_ORIGIN, new OctetStringEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.18", Collections.singletonList("octetStringOrderingMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.40", RFC4512_ORIGIN, new OctetStringOrderingMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.19", Collections.singletonList("octetStringSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.40", X500_ORIGIN, new OctetStringSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.24", Collections.singletonList("protocolInformationMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.42", RFC2252_ORIGIN, new ProtocolInformationEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.22", Collections.singletonList("presentationAddressMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.43", RFC2252_ORIGIN, new PresentationAddressEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.20", Collections.singletonList("telephoneNumberMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.50", RFC4512_ORIGIN, new TelephoneNumberEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.21", Collections.singletonList("telephoneNumberSubstringsMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.58", RFC4512_ORIGIN, new TelephoneNumberSubstringMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.23", Collections.singletonList("uniqueMemberMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.34", RFC4512_ORIGIN, new UniqueMemberEqualityMatchingRuleImpl(), false);
        builder.addMatchingRule("2.5.13.32", Collections.singletonList("wordMatch"), EMPTY_STRING, false, "1.3.6.1.4.1.1466.115.121.1.15", RFC4512_ORIGIN, new WordEqualityMatchingRuleImpl(), false);
    }

    private static void defaultObjectClasses(SchemaBuilder builder) {
        builder.addObjectClass("2.5.6.0", Collections.singletonList("top"), "Topmost ObjectClass", false, EMPTY_STRING_SET, Collections.singleton("objectClass"), EMPTY_STRING_SET, ObjectClassType.ABSTRACT, RFC4512_ORIGIN, false);
        builder.addObjectClass("2.5.6.1", Collections.singletonList("alias"), EMPTY_STRING, false, Collections.singleton("top"), Collections.singleton("aliasedObjectName"), EMPTY_STRING_SET, ObjectClassType.STRUCTURAL, RFC4512_ORIGIN, false);
        builder.addObjectClass("1.3.6.1.4.1.1466.101.120.111", Collections.singletonList("extensibleObject"), EMPTY_STRING, false, Collections.singleton("top"), EMPTY_STRING_SET, EMPTY_STRING_SET, ObjectClassType.AUXILIARY, RFC4512_ORIGIN, false);
        HashSet<String> subschemaAttrs = new HashSet<String>();
        subschemaAttrs.add("dITStructureRules");
        subschemaAttrs.add("nameForms");
        subschemaAttrs.add("ditContentRules");
        subschemaAttrs.add("objectClasses");
        subschemaAttrs.add("attributeTypes");
        subschemaAttrs.add("matchingRules");
        subschemaAttrs.add("matchingRuleUse");
        builder.addObjectClass("2.5.20.1", Collections.singletonList("subschema"), EMPTY_STRING, false, Collections.singleton("top"), EMPTY_STRING_SET, subschemaAttrs, ObjectClassType.AUXILIARY, RFC4512_ORIGIN, false);
    }

    private static void defaultSyntaxes(SchemaBuilder builder) {
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.3", "Attribute Type Description", RFC4512_ORIGIN, new AttributeTypeSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.5", "Binary", RFC4512_ORIGIN, new BinarySyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.6", "Bit String", RFC4512_ORIGIN, new BitStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.7", "Boolean", RFC4512_ORIGIN, new BooleanSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.9", "Certificate List", RFC4512_ORIGIN, new CertificateListSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.10", "Certificate Pair", RFC4512_ORIGIN, new CertificatePairSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.8", "Certificate", RFC4512_ORIGIN, new CertificateSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.11", "Country String", RFC4512_ORIGIN, new CountryStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.14", "Delivery Method", RFC4512_ORIGIN, new DeliveryMethodSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.15", "Directory String", RFC4512_ORIGIN, new DirectoryStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.16", "DIT Content Rule Description", RFC4512_ORIGIN, new DITContentRuleSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.17", "DIT Structure Rule Description", RFC4512_ORIGIN, new DITStructureRuleSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.12", "DN", RFC4512_ORIGIN, new DistinguishedNameSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.21", "Enhanced Guide", RFC4512_ORIGIN, new EnhancedGuideSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.22", "Facsimile Telephone Number", RFC4512_ORIGIN, new FacsimileNumberSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.23", "Fax", RFC4512_ORIGIN, new FaxSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.24", "Generalized Time", RFC4512_ORIGIN, new GeneralizedTimeSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.25", "Guide", RFC4512_ORIGIN, new GuideSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.26", "IA5 String", RFC4512_ORIGIN, new IA5StringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.27", "Integer", RFC4512_ORIGIN, new IntegerSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.28", "JPEG", RFC4512_ORIGIN, new JPEGSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.30", "Matching Rule Description", RFC4512_ORIGIN, new MatchingRuleSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.31", "Matching Rule Use Description", RFC4512_ORIGIN, new MatchingRuleUseSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.54", "LDAP Syntax Description", RFC4512_ORIGIN, new LDAPSyntaxDescriptionSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.34", "Name and Optional UID", RFC4517_ORIGIN, new NameAndOptionalUIDSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.35", "Name Form Description", RFC4512_ORIGIN, new NameFormSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.36", "Numeric String", RFC4512_ORIGIN, new NumericStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.37", "Object Class Description", RFC4512_ORIGIN, new ObjectClassSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.40", "Octet String", RFC4512_ORIGIN, new OctetStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.38", "OID", RFC4512_ORIGIN, new OIDSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.39", "Other Mailbox", RFC4512_ORIGIN, new OtherMailboxSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.41", "Postal Address", RFC4512_ORIGIN, new PostalAddressSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.43", "Presentation Address", RFC2252_ORIGIN, new PresentationAddressSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.44", "Printable String", RFC4512_ORIGIN, new PrintableStringSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.42", "Protocol Information", RFC2252_ORIGIN, new ProtocolInformationSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.58", "Substring Assertion", RFC4512_ORIGIN, new SubstringAssertionSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.49", "Supported Algorithm", RFC4512_ORIGIN, new SupportedAlgorithmSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.50", "Telephone Number", RFC4512_ORIGIN, new TelephoneNumberSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.51", "Teletex Terminal Identifier", RFC4512_ORIGIN, new TeletexTerminalIdentifierSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.52", "Telex Number", RFC4512_ORIGIN, new TelexNumberSyntaxImpl(), false);
        builder.addSyntax("1.3.6.1.4.1.1466.115.121.1.53", "UTC Time", RFC4512_ORIGIN, new UTCTimeSyntaxImpl(), false);
    }

    private CoreSchemaImpl() {
    }

    static {
        SchemaBuilder builder = new SchemaBuilder("Core Schema");
        CoreSchemaImpl.defaultSyntaxes(builder);
        CoreSchemaImpl.defaultMatchingRules(builder);
        CoreSchemaImpl.defaultAttributeTypes(builder);
        CoreSchemaImpl.defaultObjectClasses(builder);
        CoreSchemaImpl.addRFC4519(builder);
        CoreSchemaImpl.addRFC4530(builder);
        CoreSchemaImpl.addRFC3045(builder);
        CoreSchemaImpl.addRFC3112(builder);
        CoreSchemaImpl.addRFC5020(builder);
        CoreSchemaImpl.addSunProprietary(builder);
        SINGLETON = builder.toSchema().asNonStrictSchema();
    }
}

