/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class AuthPasswordSyntaxImpl
extends AbstractSyntaxImpl {
    AuthPasswordSyntaxImpl() {
    }

    static StringBuilder[] decodeAuthPassword(String authPasswordValue) throws DecodeException {
        char c;
        int pos;
        StringBuilder scheme = new StringBuilder();
        StringBuilder authInfo = new StringBuilder();
        StringBuilder authValue = new StringBuilder();
        int length = authPasswordValue.length();
        for (pos = 0; pos < length && authPasswordValue.charAt(pos) == ' '; ++pos) {
        }
        block5: while (pos < length) {
            c = authPasswordValue.charAt(pos);
            switch (c) {
                case '-': 
                case '.': 
                case '/': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': {
                    scheme.append(c);
                    ++pos;
                    break;
                }
                case ' ': 
                case '$': {
                    break block5;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_SCHEME_CHAR.get((Object)pos);
                    throw DecodeException.error(message);
                }
            }
        }
        if (scheme.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME.get();
            throw DecodeException.error(message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_SCHEME_SEPARATOR.get();
            throw DecodeException.error(message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                authInfo.append(c);
                ++pos;
                continue;
            }
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_INFO_CHAR.get((Object)pos);
            throw DecodeException.error(message);
        }
        if (scheme.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO.get();
            throw DecodeException.error(message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        if (pos < length && authPasswordValue.charAt(pos) == '$') {
            ++pos;
        } else {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_INFO_SEPARATOR.get();
            throw DecodeException.error(message);
        }
        while (pos < length && authPasswordValue.charAt(pos) == ' ') {
            ++pos;
        }
        while (pos < length && (c = authPasswordValue.charAt(pos)) != ' ' && c != '$') {
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                authValue.append(c);
                ++pos;
                continue;
            }
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_AUTH_VALUE_CHAR.get((Object)pos);
            throw DecodeException.error(message);
        }
        if (scheme.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_NO_AUTH_VALUE.get();
            throw DecodeException.error(message);
        }
        while (pos < length) {
            c = authPasswordValue.charAt(pos);
            if (c == ' ') {
                ++pos;
                continue;
            }
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_AUTHPW_INVALID_TRAILING_CHAR.get((Object)pos);
            throw DecodeException.error(message);
        }
        return new StringBuilder[]{scheme, authInfo, authValue};
    }

    static boolean isEncoded(ByteSequence value) {
        try {
            AuthPasswordSyntaxImpl.decodeAuthPassword(value.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getEqualityMatchingRule() {
        return "1.3.6.1.4.1.4203.1.2.2";
    }

    @Override
    public String getName() {
        return "AuthenticationPasswordSyntax";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        try {
            AuthPasswordSyntaxImpl.decodeAuthPassword(value.toString());
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }
}

