/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

abstract class AbstractOrderingMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    AbstractOrderingMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                return attributeValue.compareTo(normAssertion) < 0 ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        };
    }

    @Override
    public Assertion getGreaterOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                return attributeValue.compareTo(normAssertion) >= 0 ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        };
    }

    @Override
    public Assertion getLessOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final ByteString normAssertion = this.normalizeAttributeValue(schema, value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                return attributeValue.compareTo(normAssertion) <= 0 ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        };
    }
}

