/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResult;
import org.forgerock.opendj.ldap.responses.WhoAmIExtendedResult;

final class WhoAmIExtendedResultImpl
extends AbstractExtendedResult<WhoAmIExtendedResult>
implements WhoAmIExtendedResult {
    private String authorizationID = null;

    WhoAmIExtendedResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    WhoAmIExtendedResultImpl(WhoAmIExtendedResult whoAmIExtendedResult) {
        super(whoAmIExtendedResult);
        this.authorizationID = whoAmIExtendedResult.getAuthorizationID();
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getOID() {
        return null;
    }

    @Override
    public ByteString getValue() {
        return this.authorizationID != null ? ByteString.valueOf(this.authorizationID) : null;
    }

    @Override
    public boolean hasValue() {
        return this.authorizationID != null;
    }

    @Override
    public WhoAmIExtendedResult setAuthorizationID(String authorizationID) {
        int colonIndex;
        if (authorizationID != null && authorizationID.length() != 0 && (colonIndex = authorizationID.indexOf(58)) < 0) {
            LocalizableMessage message = CoreMessages.ERR_WHOAMI_INVALID_AUTHZID_TYPE.get((Object)authorizationID);
            throw new LocalizedIllegalArgumentException(message);
        }
        this.authorizationID = authorizationID;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WhoAmIExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        builder.append(", authzId=");
        builder.append(this.authorizationID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

