/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.responses.Response;

abstract class AbstractResponseImpl<S extends Response>
implements Response {
    private final List<Control> controls = new LinkedList<Control>();

    static Control getControl(List<Control> controls, String oid) {
        if (!controls.isEmpty()) {
            for (Control control : controls) {
                if (!control.getOID().equals(oid)) continue;
                return control;
            }
        }
        return null;
    }

    AbstractResponseImpl() {
    }

    AbstractResponseImpl(Response response) {
        Validator.ensureNotNull(response);
        for (Control control : response.getControls()) {
            this.controls.add(GenericControl.newControl(control));
        }
    }

    public final S addControl(Control control) {
        Validator.ensureNotNull(control);
        this.controls.add(control);
        return this.getThis();
    }

    @Override
    public boolean containsControl(String oid) {
        return AbstractResponseImpl.getControl(this.controls, oid) != null;
    }

    @Override
    public final <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
        Validator.ensureNotNull(decoder, (Object)options);
        Control control = AbstractResponseImpl.getControl(this.controls, decoder.getOID());
        return control != null ? (C)decoder.decodeControl(control, options) : null;
    }

    @Override
    public final List<Control> getControls() {
        return this.controls;
    }

    public abstract String toString();

    abstract S getThis();
}

