/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;

final class GenericExtendedRequestImpl
extends AbstractExtendedRequest<GenericExtendedRequest, GenericExtendedResult>
implements GenericExtendedRequest {
    private static final GenericExtendedResultDecoder RESULT_DECODER = new GenericExtendedResultDecoder();
    private String requestName;
    private ByteString requestValue = null;

    GenericExtendedRequestImpl(GenericExtendedRequest genericExtendedRequest) {
        super(genericExtendedRequest);
        this.requestName = genericExtendedRequest.getOID();
        this.requestValue = genericExtendedRequest.getValue();
    }

    GenericExtendedRequestImpl(String requestName) {
        this.requestName = requestName;
    }

    @Override
    public String getOID() {
        return this.requestName;
    }

    @Override
    public ExtendedResultDecoder<GenericExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        return this.requestValue;
    }

    @Override
    public boolean hasValue() {
        return this.requestValue != null;
    }

    @Override
    public GenericExtendedRequest setOID(String oid) {
        Validator.ensureNotNull(oid);
        this.requestName = oid;
        return this;
    }

    @Override
    public GenericExtendedRequest setValue(Object value) {
        this.requestValue = value != null ? ByteString.valueOf(value) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericExtendedRequest(requestName=");
        builder.append(this.getOID());
        if (this.hasValue()) {
            builder.append(", requestValue=");
            StaticUtils.toHexPlusAscii(this.getValue(), builder, 4);
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class GenericExtendedResultDecoder
    extends AbstractExtendedResultDecoder<GenericExtendedResult> {
        private GenericExtendedResultDecoder() {
        }

        @Override
        public GenericExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof GenericExtendedResult) {
                return (GenericExtendedResult)result;
            }
            GenericExtendedResult newResult = Responses.newGenericExtendedResult(result.getResultCode()).setMatchedDN(result.getMatchedDN()).setDiagnosticMessage(result.getDiagnosticMessage()).setOID(result.getOID()).setValue(result.getValue());
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }

        @Override
        public GenericExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<GenericExtendedRequest, GenericExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public GenericExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            if (request instanceof GenericExtendedRequest) {
                return (GenericExtendedRequest)request;
            }
            GenericExtendedRequest newRequest = new GenericExtendedRequestImpl(request.getOID()).setValue(request.getValue());
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

