/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.requests.AbstractSASLBindRequest;
import org.forgerock.opendj.ldap.requests.AnonymousSASLBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.SASLBindClientImpl;

final class AnonymousSASLBindRequestImpl
extends AbstractSASLBindRequest<AnonymousSASLBindRequest>
implements AnonymousSASLBindRequest {
    private String traceString;

    AnonymousSASLBindRequestImpl(AnonymousSASLBindRequest anonymousSASLBindRequest) {
        super(anonymousSASLBindRequest);
        this.traceString = anonymousSASLBindRequest.getTraceString();
    }

    AnonymousSASLBindRequestImpl(String traceString) {
        Validator.ensureNotNull(traceString);
        this.traceString = traceString;
    }

    @Override
    public BindClient createBindClient(String serverName) {
        return new Client(this, serverName);
    }

    @Override
    public String getSASLMechanism() {
        return "ANONYMOUS";
    }

    @Override
    public String getTraceString() {
        return this.traceString;
    }

    @Override
    public AnonymousSASLBindRequest setTraceString(String traceString) {
        Validator.ensureNotNull(traceString);
        this.traceString = traceString;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnonymousSASLBindRequest(bindDN=");
        builder.append(this.getName());
        builder.append(", authentication=SASL");
        builder.append(", saslMechanism=");
        builder.append(this.getSASLMechanism());
        builder.append(", traceString=");
        builder.append(this.traceString);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class Client
    extends SASLBindClientImpl {
        private Client(AnonymousSASLBindRequestImpl initialBindRequest, String serverName) {
            super(initialBindRequest);
            this.setNextSASLCredentials(ByteString.valueOf(initialBindRequest.getTraceString()));
        }
    }
}

