/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.LDAPUtils;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.AbstractFilterVisitor;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class MatchedValuesRequestControl
implements Control {
    public static final String OID = "1.2.826.0.1.3344810.2.3";
    public static final ControlDecoder<MatchedValuesRequestControl> DECODER = new ControlDecoder<MatchedValuesRequestControl>(){

        @Override
        public MatchedValuesRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof MatchedValuesRequestControl) {
                return (MatchedValuesRequestControl)control;
            }
            if (!control.getOID().equals(MatchedValuesRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)MatchedValuesRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                if (!reader.hasNextElement()) {
                    LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_NO_FILTERS.get();
                    throw DecodeException.error(message);
                }
                LinkedList<Filter> filters = new LinkedList<Filter>();
                do {
                    Filter filter = LDAPUtils.decodeFilter(reader);
                    try {
                        MatchedValuesRequestControl.validateFilter(filter);
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        throw DecodeException.error(e.getMessageObject());
                    }
                    filters.add(filter);
                } while (reader.hasNextElement());
                reader.readEndSequence();
                return new MatchedValuesRequestControl(control.isCritical(), Collections.unmodifiableList(filters));
            }
            catch (IOException e) {
                StaticUtils.DEBUG_LOG.throwing("MatchedValuesControl.Decoder", "decode", e);
                LocalizableMessage message = CoreMessages.ERR_MATCHEDVALUES_CANNOT_DECODE_VALUE_AS_SEQUENCE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message);
            }
        }

        @Override
        public String getOID() {
            return MatchedValuesRequestControl.OID;
        }
    };
    private static final FilterValidator FILTER_VALIDATOR = new FilterValidator();
    private final Collection<Filter> filters;
    private final boolean isCritical;

    public static MatchedValuesRequestControl newControl(boolean isCritical, Collection<Filter> filters) {
        List<Object> copyOfFilters;
        Validator.ensureNotNull(filters);
        Validator.ensureTrue(filters.size() > 0, "filters is empty");
        if (filters.size() == 1) {
            copyOfFilters = Collections.singletonList(MatchedValuesRequestControl.validateFilter(filters.iterator().next()));
        } else {
            copyOfFilters = new ArrayList(filters.size());
            for (Filter filter : filters) {
                copyOfFilters.add(MatchedValuesRequestControl.validateFilter(filter));
            }
            copyOfFilters = Collections.unmodifiableList(copyOfFilters);
        }
        return new MatchedValuesRequestControl(isCritical, copyOfFilters);
    }

    public static MatchedValuesRequestControl newControl(boolean isCritical, String ... filters) {
        Validator.ensureTrue(filters.length > 0, "filters is empty");
        ArrayList<Filter> parsedFilters = new ArrayList<Filter>(filters.length);
        for (String filter : filters) {
            parsedFilters.add(MatchedValuesRequestControl.validateFilter(Filter.valueOf(filter)));
        }
        return new MatchedValuesRequestControl(isCritical, Collections.unmodifiableList(parsedFilters));
    }

    private static Filter validateFilter(Filter filter) {
        LocalizedIllegalArgumentException e = filter.accept(FILTER_VALIDATOR, filter);
        if (e != null) {
            throw e;
        }
        return filter;
    }

    private MatchedValuesRequestControl(boolean isCritical, Collection<Filter> filters) {
        this.isCritical = isCritical;
        this.filters = filters;
    }

    public Collection<Filter> getFilters() {
        return this.filters;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            for (Filter f : this.filters) {
                LDAPUtils.encodeFilter(writer, f);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MatchedValuesRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }

    private static final class FilterValidator
    extends AbstractFilterVisitor<LocalizedIllegalArgumentException, Filter> {
        private FilterValidator() {
        }

        @Override
        public LocalizedIllegalArgumentException visitAndFilter(Filter p, List<Filter> subFilters) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_AND.get((Object)p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitExtensibleMatchFilter(Filter p, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            if (dnAttributes) {
                LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_EXT.get((Object)p.toString());
                return new LocalizedIllegalArgumentException(message);
            }
            return null;
        }

        @Override
        public LocalizedIllegalArgumentException visitNotFilter(Filter p, Filter subFilter) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_NOT.get((Object)p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitOrFilter(Filter p, List<Filter> subFilters) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_OR.get((Object)p.toString());
            return new LocalizedIllegalArgumentException(message);
        }

        @Override
        public LocalizedIllegalArgumentException visitUnrecognizedFilter(Filter p, byte filterTag, ByteString filterBytes) {
            LocalizableMessage message = CoreMessages.ERR_MVFILTER_BAD_FILTER_UNRECOGNIZED.get((Object)p.toString(), (Object)filterTag);
            return new LocalizedIllegalArgumentException(message);
        }
    }
}

