/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class GetEffectiveRightsRequestControl
implements Control {
    public static final String OID = "1.3.6.1.4.1.42.2.27.9.5.2";
    public static final ControlDecoder<GetEffectiveRightsRequestControl> DECODER = new ControlDecoder<GetEffectiveRightsRequestControl>(){

        @Override
        public GetEffectiveRightsRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof GetEffectiveRightsRequestControl) {
                return (GetEffectiveRightsRequestControl)control;
            }
            if (!control.getOID().equals(GetEffectiveRightsRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_GETEFFECTIVERIGHTS_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)GetEffectiveRightsRequestControl.OID);
                throw DecodeException.error(message);
            }
            DN authorizationDN = null;
            List attributes = Collections.emptyList();
            if (control.hasValue()) {
                ASN1Reader reader = ASN1.getReader(control.getValue());
                try {
                    Schema schema;
                    reader.readStartSequence();
                    String authzIDString = reader.readOctetStringAsString();
                    String lowerAuthzIDString = authzIDString.toLowerCase();
                    if (lowerAuthzIDString.startsWith("dn:")) {
                        String authorizationDNString = authzIDString.substring(3);
                        schema = options.getSchemaResolver().resolveSchema(authorizationDNString);
                        try {
                            authorizationDN = DN.valueOf(authorizationDNString, schema);
                        }
                        catch (LocalizedIllegalArgumentException e) {
                            LocalizableMessage message = CoreMessages.ERR_GETEFFECTIVERIGHTS_INVALID_AUTHZIDDN.get((Object)StaticUtils.getExceptionMessage(e));
                            throw DecodeException.error(message, e);
                        }
                    } else {
                        LocalizableMessage message = CoreMessages.INFO_GETEFFECTIVERIGHTS_INVALID_AUTHZID.get((Object)lowerAuthzIDString);
                        throw DecodeException.error(message);
                    }
                    if (reader.hasNextElement()) {
                        attributes = new LinkedList();
                        reader.readStartSequence();
                        while (reader.hasNextElement()) {
                            AttributeType attributeType;
                            String attributeName = reader.readOctetStringAsString();
                            try {
                                attributeType = schema.getAttributeType(attributeName);
                            }
                            catch (UnknownSchemaElementException e) {
                                LocalizableMessage message = CoreMessages.ERR_GETEFFECTIVERIGHTS_UNKNOWN_ATTRIBUTE.get((Object)attributeName);
                                throw DecodeException.error(message, (Throwable)((Object)e));
                            }
                            attributes.add(attributeType);
                        }
                        reader.readEndSequence();
                        attributes = Collections.unmodifiableList(attributes);
                    }
                    reader.readEndSequence();
                }
                catch (IOException e) {
                    LocalizableMessage message = CoreMessages.INFO_GETEFFECTIVERIGHTS_DECODE_ERROR.get((Object)e.getMessage());
                    throw DecodeException.error(message);
                }
            }
            return new GetEffectiveRightsRequestControl(control.isCritical(), authorizationDN, attributes);
        }

        @Override
        public String getOID() {
            return GetEffectiveRightsRequestControl.OID;
        }
    };
    private final DN authorizationName;
    private final Collection<AttributeType> attributes;
    private final boolean isCritical;

    public static GetEffectiveRightsRequestControl newControl(boolean isCritical, DN authorizationName, Collection<AttributeType> attributes) {
        Validator.ensureNotNull(attributes);
        List<AttributeType> copyOfAttributes = Collections.unmodifiableList(new ArrayList<AttributeType>(attributes));
        return new GetEffectiveRightsRequestControl(isCritical, authorizationName, copyOfAttributes);
    }

    public static GetEffectiveRightsRequestControl newControl(boolean isCritical, String authorizationName, String ... attributes) {
        List<AttributeType> copyOfAttributes;
        DN dn;
        Validator.ensureNotNull(attributes);
        DN dN = dn = authorizationName == null ? null : DN.valueOf(authorizationName);
        if (attributes != null && attributes.length > 0) {
            copyOfAttributes = new ArrayList<AttributeType>(attributes.length);
            for (String attribute : attributes) {
                copyOfAttributes.add(Schema.getDefaultSchema().getAttributeType(attribute));
            }
            copyOfAttributes = Collections.unmodifiableList(copyOfAttributes);
        } else {
            copyOfAttributes = Collections.emptyList();
        }
        return new GetEffectiveRightsRequestControl(isCritical, dn, copyOfAttributes);
    }

    private GetEffectiveRightsRequestControl(boolean isCritical, DN authorizationName, Collection<AttributeType> attributes) {
        this.isCritical = isCritical;
        this.authorizationName = authorizationName;
        this.attributes = attributes;
    }

    public Collection<AttributeType> getAttributes() {
        return this.attributes;
    }

    public DN getAuthorizationName() {
        return this.authorizationName;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.authorizationName != null) {
                writer.writeOctetString("dn:" + this.authorizationName);
            }
            if (!this.attributes.isEmpty()) {
                writer.writeStartSequence();
                for (AttributeType attribute : this.attributes) {
                    writer.writeOctetString(attribute.getNameOrOID());
                }
                writer.writeEndSequence();
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return this.authorizationName != null || !this.attributes.isEmpty();
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetEffectiveRightsRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", authorizationDN=\"");
        builder.append(this.authorizationName);
        builder.append("\"");
        builder.append(", attributes=(");
        builder.append(this.attributes);
        builder.append("))");
        return builder.toString();
    }
}

