/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.opendj.ldap.AbstractLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.ConnectionFactory;

public final class RoundRobinLoadBalancingAlgorithm
extends AbstractLoadBalancingAlgorithm {
    private final int maxIndex;
    private final AtomicInteger nextIndex = new AtomicInteger(-1);

    public RoundRobinLoadBalancingAlgorithm(Collection<ConnectionFactory> factories) {
        super(factories);
        this.maxIndex = factories.size();
    }

    public RoundRobinLoadBalancingAlgorithm(Collection<ConnectionFactory> factories, long interval, TimeUnit unit) {
        super(factories, interval, unit);
        this.maxIndex = factories.size();
    }

    public RoundRobinLoadBalancingAlgorithm(Collection<ConnectionFactory> factories, long interval, TimeUnit unit, ScheduledExecutorService scheduler) {
        super(factories, interval, unit, scheduler);
        this.maxIndex = factories.size();
    }

    @Override
    String getAlgorithmName() {
        return "RoundRobin";
    }

    @Override
    int getInitialConnectionFactoryIndex() {
        int newNextIndex;
        int oldNextIndex;
        if (this.maxIndex == 1) {
            return 0;
        }
        do {
            if ((newNextIndex = (oldNextIndex = this.nextIndex.get()) + 1) != this.maxIndex) continue;
            newNextIndex = 0;
        } while (!this.nextIndex.compareAndSet(oldNextIndex, newNextIndex));
        return newNextIndex;
    }
}

