/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;

public final class ResultCode {
    private static final ResultCode[] ELEMENTS = new ResultCode[16655];
    private static final List<ResultCode> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final ResultCode SUCCESS = ResultCode.registerSuccessResultCode(0, CoreMessages.INFO_RESULT_SUCCESS.get());
    public static final ResultCode OPERATIONS_ERROR = ResultCode.registerErrorResultCode(1, CoreMessages.INFO_RESULT_OPERATIONS_ERROR.get());
    public static final ResultCode PROTOCOL_ERROR = ResultCode.registerErrorResultCode(2, CoreMessages.INFO_RESULT_PROTOCOL_ERROR.get());
    public static final ResultCode TIME_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(3, CoreMessages.INFO_RESULT_TIME_LIMIT_EXCEEDED.get());
    public static final ResultCode SIZE_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(4, CoreMessages.INFO_RESULT_SIZE_LIMIT_EXCEEDED.get());
    public static final ResultCode COMPARE_FALSE = ResultCode.registerSuccessResultCode(5, CoreMessages.INFO_RESULT_COMPARE_FALSE.get());
    public static final ResultCode COMPARE_TRUE = ResultCode.registerSuccessResultCode(6, CoreMessages.INFO_RESULT_COMPARE_TRUE.get());
    public static final ResultCode AUTH_METHOD_NOT_SUPPORTED = ResultCode.registerErrorResultCode(7, CoreMessages.INFO_RESULT_AUTH_METHOD_NOT_SUPPORTED.get());
    public static final ResultCode STRONG_AUTH_REQUIRED = ResultCode.registerErrorResultCode(8, CoreMessages.INFO_RESULT_STRONG_AUTH_REQUIRED.get());
    public static final ResultCode REFERRAL = ResultCode.registerErrorResultCode(10, CoreMessages.INFO_RESULT_REFERRAL.get());
    public static final ResultCode ADMIN_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(11, CoreMessages.INFO_RESULT_ADMIN_LIMIT_EXCEEDED.get());
    public static final ResultCode UNAVAILABLE_CRITICAL_EXTENSION = ResultCode.registerErrorResultCode(12, CoreMessages.INFO_RESULT_UNAVAILABLE_CRITICAL_EXTENSION.get());
    public static final ResultCode CONFIDENTIALITY_REQUIRED = ResultCode.registerErrorResultCode(13, CoreMessages.INFO_RESULT_CONFIDENTIALITY_REQUIRED.get());
    public static final ResultCode SASL_BIND_IN_PROGRESS = ResultCode.registerSuccessResultCode(14, CoreMessages.INFO_RESULT_SASL_BIND_IN_PROGRESS.get());
    public static final ResultCode NO_SUCH_ATTRIBUTE = ResultCode.registerErrorResultCode(16, CoreMessages.INFO_RESULT_NO_SUCH_ATTRIBUTE.get());
    public static final ResultCode UNDEFINED_ATTRIBUTE_TYPE = ResultCode.registerErrorResultCode(17, CoreMessages.INFO_RESULT_UNDEFINED_ATTRIBUTE_TYPE.get());
    public static final ResultCode INAPPROPRIATE_MATCHING = ResultCode.registerErrorResultCode(18, CoreMessages.INFO_RESULT_INAPPROPRIATE_MATCHING.get());
    public static final ResultCode CONSTRAINT_VIOLATION = ResultCode.registerErrorResultCode(19, CoreMessages.INFO_RESULT_CONSTRAINT_VIOLATION.get());
    public static final ResultCode ATTRIBUTE_OR_VALUE_EXISTS = ResultCode.registerErrorResultCode(20, CoreMessages.INFO_RESULT_ATTRIBUTE_OR_VALUE_EXISTS.get());
    public static final ResultCode INVALID_ATTRIBUTE_SYNTAX = ResultCode.registerErrorResultCode(21, CoreMessages.INFO_RESULT_INVALID_ATTRIBUTE_SYNTAX.get());
    public static final ResultCode NO_SUCH_OBJECT = ResultCode.registerErrorResultCode(32, CoreMessages.INFO_RESULT_NO_SUCH_OBJECT.get());
    public static final ResultCode ALIAS_PROBLEM = ResultCode.registerErrorResultCode(33, CoreMessages.INFO_RESULT_ALIAS_PROBLEM.get());
    public static final ResultCode INVALID_DN_SYNTAX = ResultCode.registerErrorResultCode(34, CoreMessages.INFO_RESULT_INVALID_DN_SYNTAX.get());
    public static final ResultCode ALIAS_DEREFERENCING_PROBLEM = ResultCode.registerErrorResultCode(36, CoreMessages.INFO_RESULT_ALIAS_DEREFERENCING_PROBLEM.get());
    public static final ResultCode INAPPROPRIATE_AUTHENTICATION = ResultCode.registerErrorResultCode(48, CoreMessages.INFO_RESULT_INAPPROPRIATE_AUTHENTICATION.get());
    public static final ResultCode INVALID_CREDENTIALS = ResultCode.registerErrorResultCode(49, CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get());
    public static final ResultCode INSUFFICIENT_ACCESS_RIGHTS = ResultCode.registerErrorResultCode(50, CoreMessages.INFO_RESULT_INSUFFICIENT_ACCESS_RIGHTS.get());
    public static final ResultCode BUSY = ResultCode.registerErrorResultCode(51, CoreMessages.INFO_RESULT_BUSY.get());
    public static final ResultCode UNAVAILABLE = ResultCode.registerErrorResultCode(52, CoreMessages.INFO_RESULT_UNAVAILABLE.get());
    public static final ResultCode UNWILLING_TO_PERFORM = ResultCode.registerErrorResultCode(53, CoreMessages.INFO_RESULT_UNWILLING_TO_PERFORM.get());
    public static final ResultCode LOOP_DETECT = ResultCode.registerErrorResultCode(54, CoreMessages.INFO_RESULT_LOOP_DETECT.get());
    public static final ResultCode SORT_CONTROL_MISSING = ResultCode.registerErrorResultCode(60, CoreMessages.INFO_RESULT_SORT_CONTROL_MISSING.get());
    public static final ResultCode OFFSET_RANGE_ERROR = ResultCode.registerErrorResultCode(61, CoreMessages.INFO_RESULT_OFFSET_RANGE_ERROR.get());
    public static final ResultCode NAMING_VIOLATION = ResultCode.registerErrorResultCode(64, CoreMessages.INFO_RESULT_NAMING_VIOLATION.get());
    public static final ResultCode OBJECTCLASS_VIOLATION = ResultCode.registerErrorResultCode(65, CoreMessages.INFO_RESULT_OBJECTCLASS_VIOLATION.get());
    public static final ResultCode NOT_ALLOWED_ON_NONLEAF = ResultCode.registerErrorResultCode(66, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_NONLEAF.get());
    public static final ResultCode NOT_ALLOWED_ON_RDN = ResultCode.registerErrorResultCode(67, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_RDN.get());
    public static final ResultCode ENTRY_ALREADY_EXISTS = ResultCode.registerErrorResultCode(68, CoreMessages.INFO_RESULT_ENTRY_ALREADY_EXISTS.get());
    public static final ResultCode OBJECTCLASS_MODS_PROHIBITED = ResultCode.registerErrorResultCode(69, CoreMessages.INFO_RESULT_OBJECTCLASS_MODS_PROHIBITED.get());
    public static final ResultCode AFFECTS_MULTIPLE_DSAS = ResultCode.registerErrorResultCode(71, CoreMessages.INFO_RESULT_AFFECTS_MULTIPLE_DSAS.get());
    public static final ResultCode VIRTUAL_LIST_VIEW_ERROR = ResultCode.registerErrorResultCode(76, CoreMessages.INFO_RESULT_VIRTUAL_LIST_VIEW_ERROR.get());
    public static final ResultCode OTHER = ResultCode.registerErrorResultCode(80, CoreMessages.INFO_RESULT_OTHER.get());
    public static final ResultCode CLIENT_SIDE_SERVER_DOWN = ResultCode.registerErrorResultCode(81, CoreMessages.INFO_RESULT_CLIENT_SIDE_SERVER_DOWN.get());
    public static final ResultCode CLIENT_SIDE_LOCAL_ERROR = ResultCode.registerErrorResultCode(82, CoreMessages.INFO_RESULT_CLIENT_SIDE_LOCAL_ERROR.get());
    public static final ResultCode CLIENT_SIDE_ENCODING_ERROR = ResultCode.registerErrorResultCode(83, CoreMessages.INFO_RESULT_CLIENT_SIDE_ENCODING_ERROR.get());
    public static final ResultCode CLIENT_SIDE_DECODING_ERROR = ResultCode.registerErrorResultCode(84, CoreMessages.INFO_RESULT_CLIENT_SIDE_DECODING_ERROR.get());
    public static final ResultCode CLIENT_SIDE_TIMEOUT = ResultCode.registerErrorResultCode(85, CoreMessages.INFO_RESULT_CLIENT_SIDE_TIMEOUT.get());
    public static final ResultCode CLIENT_SIDE_AUTH_UNKNOWN = ResultCode.registerErrorResultCode(86, CoreMessages.INFO_RESULT_CLIENT_SIDE_AUTH_UNKNOWN.get());
    public static final ResultCode CLIENT_SIDE_FILTER_ERROR = ResultCode.registerErrorResultCode(87, CoreMessages.INFO_RESULT_CLIENT_SIDE_FILTER_ERROR.get());
    public static final ResultCode CLIENT_SIDE_USER_CANCELLED = ResultCode.registerErrorResultCode(88, CoreMessages.INFO_RESULT_CLIENT_SIDE_USER_CANCELLED.get());
    public static final ResultCode CLIENT_SIDE_PARAM_ERROR = ResultCode.registerErrorResultCode(89, CoreMessages.INFO_RESULT_CLIENT_SIDE_PARAM_ERROR.get());
    public static final ResultCode CLIENT_SIDE_NO_MEMORY = ResultCode.registerErrorResultCode(90, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_MEMORY.get());
    public static final ResultCode CLIENT_SIDE_CONNECT_ERROR = ResultCode.registerErrorResultCode(91, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get());
    public static final ResultCode CLIENT_SIDE_NOT_SUPPORTED = ResultCode.registerErrorResultCode(92, CoreMessages.INFO_RESULT_CLIENT_SIDE_NOT_SUPPORTED.get());
    public static final ResultCode CLIENT_SIDE_CONTROL_NOT_FOUND = ResultCode.registerErrorResultCode(93, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONTROL_NOT_FOUND.get());
    public static final ResultCode CLIENT_SIDE_NO_RESULTS_RETURNED = ResultCode.registerErrorResultCode(94, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_RESULTS_RETURNED.get());
    public static final ResultCode CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED = ResultCode.registerErrorResultCode(95, CoreMessages.INFO_RESULT_CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED.get());
    public static final ResultCode CLIENT_SIDE_CLIENT_LOOP = ResultCode.registerErrorResultCode(96, CoreMessages.INFO_RESULT_CLIENT_SIDE_CLIENT_LOOP.get());
    public static final ResultCode CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED = ResultCode.registerErrorResultCode(97, CoreMessages.INFO_RESULT_CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED.get());
    public static final ResultCode CANCELLED = ResultCode.registerErrorResultCode(118, CoreMessages.INFO_RESULT_CANCELED.get());
    public static final ResultCode NO_SUCH_OPERATION = ResultCode.registerErrorResultCode(119, CoreMessages.INFO_RESULT_NO_SUCH_OPERATION.get());
    public static final ResultCode TOO_LATE = ResultCode.registerErrorResultCode(120, CoreMessages.INFO_RESULT_TOO_LATE.get());
    public static final ResultCode CANNOT_CANCEL = ResultCode.registerErrorResultCode(121, CoreMessages.INFO_RESULT_CANNOT_CANCEL.get());
    public static final ResultCode ASSERTION_FAILED = ResultCode.registerErrorResultCode(122, CoreMessages.INFO_RESULT_ASSERTION_FAILED.get());
    public static final ResultCode AUTHORIZATION_DENIED = ResultCode.registerErrorResultCode(123, CoreMessages.INFO_RESULT_AUTHORIZATION_DENIED.get());
    public static final ResultCode NO_OPERATION = ResultCode.registerSuccessResultCode(16654, CoreMessages.INFO_RESULT_NO_OPERATION.get());
    private final int intValue;
    private final LocalizableMessage name;
    private final boolean exceptional;

    public static ResultCode valueOf(int intValue) {
        ResultCode resultCode = null;
        if (intValue >= 0 || intValue < ELEMENTS.length) {
            resultCode = ELEMENTS[intValue];
        }
        if (resultCode == null) {
            resultCode = new ResultCode(intValue, LocalizableMessage.raw((CharSequence)("undefined(" + intValue + ")"), (Object[])new Object[0]), true);
        }
        return resultCode;
    }

    public static List<ResultCode> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static ResultCode registerErrorResultCode(int intValue, LocalizableMessage name) {
        ResultCode t;
        ResultCode.ELEMENTS[intValue] = t = new ResultCode(intValue, name, true);
        return t;
    }

    private static ResultCode registerSuccessResultCode(int intValue, LocalizableMessage name) {
        ResultCode t;
        ResultCode.ELEMENTS[intValue] = t = new ResultCode(intValue, name, false);
        return t;
    }

    private ResultCode(int intValue, LocalizableMessage name, boolean exceptional) {
        this.intValue = intValue;
        this.name = name;
        this.exceptional = exceptional;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ResultCode) {
            return this.intValue == ((ResultCode)obj).intValue;
        }
        return false;
    }

    public LocalizableMessage getName() {
        return this.name;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public boolean isExceptional() {
        return this.exceptional;
    }

    public String toString() {
        return this.name.toString();
    }
}

