/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ModificationType {
    private static final ModificationType[] ELEMENTS = new ModificationType[4];
    private static final List<ModificationType> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final ModificationType ADD = ModificationType.register(0, "add");
    public static final ModificationType DELETE = ModificationType.register(1, "delete");
    public static final ModificationType REPLACE = ModificationType.register(2, "replace");
    public static final ModificationType INCREMENT = ModificationType.register(3, "increment");
    private final int intValue;
    private final String name;

    public static ModificationType valueOf(int intValue) {
        if (intValue < 0 || intValue >= ELEMENTS.length) {
            return null;
        }
        return ELEMENTS[intValue];
    }

    public static List<ModificationType> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static ModificationType register(int intValue, String name) {
        ModificationType t;
        ModificationType.ELEMENTS[intValue] = t = new ModificationType(intValue, name);
        return t;
    }

    private ModificationType(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ModificationType) {
            return this.intValue == ((ModificationType)obj).intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }
}

