/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPConnectionFactoryImpl;
import com.forgerock.opendj.util.Validator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.ResultHandler;

public final class LDAPConnectionFactory
implements ConnectionFactory {
    private final LDAPConnectionFactoryImpl impl;

    public LDAPConnectionFactory(SocketAddress address) {
        this(address, new LDAPOptions());
    }

    public LDAPConnectionFactory(SocketAddress address, LDAPOptions options) {
        Validator.ensureNotNull((Object)address, (Object)options);
        this.impl = new LDAPConnectionFactoryImpl(address, options);
    }

    public LDAPConnectionFactory(String host, int port) {
        this(host, port, new LDAPOptions());
    }

    public LDAPConnectionFactory(String host, int port, LDAPOptions options) {
        Validator.ensureNotNull((Object)host, (Object)options);
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.impl = new LDAPConnectionFactoryImpl(address, options);
    }

    public InetAddress getAddress() {
        SocketAddress socketAddress = this.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getAddress();
        }
        return null;
    }

    @Override
    public void close() {
        this.impl.close();
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        return this.impl.getConnectionAsync(handler);
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        return this.impl.getConnection();
    }

    public String getHostname() {
        SocketAddress socketAddress = this.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getHostName();
        }
        return null;
    }

    public int getPort() {
        SocketAddress socketAddress = this.getSocketAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return inetSocketAddress.getPort();
        }
        return -1;
    }

    public SocketAddress getSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public String toString() {
        return this.impl.toString();
    }
}

